
//: C07:AssociativeBasics.cpp
//{-bor}
// Podstawowe operacje na kontenerach set i map
#include <cstddef>
#include <iostream>
#include <iterator>
#include <map>
#include <set>
#include "Noisy.h"
using namespace std;

int main() {
  Noisy na[7];
  // Dodawanie elementw za porednictwem konstruktora:
  set<Noisy> ns(na, na + sizeof na/sizeof(Noisy));
  // Zwyke wstawianie elementw:
  Noisy n;
  ns.insert(n);
  cout << endl;
  // Sprawdzanie zawartoci kontenera set:
  cout << "ns.count(n)= " << ns.count(n) << endl;
  if(ns.find(n) != ns.end())
    cout << "n(" << n << ") obecny w ns" << endl;
  // Wydrukowanie elementw:
  copy(ns.begin(), ns.end(),
    ostream_iterator<Noisy>(cout, " "));
  cout << endl;
  cout << "\n-----------\n";
  map<int, Noisy> nm;
  for(int i = 0; i < 10; i++)
    nm[i]; // Automatyczne tworzenie par klucz-warto
  cout << "\n-----------\n";
  for(size_t j = 0; j < nm.size(); j++)
    cout << "nm[" << j <<"] = " << nm[j] << endl;
  cout << "\n-----------\n";
  nm[10] = n;
  cout << "\n-----------\n";
  nm.insert(make_pair(47, n));
  cout << "\n-----------\n";
  cout << "\n nm.count(10)= "
    << nm.count(10) << endl;
  cout << "nm.count(11)= "
    << nm.count(11) << endl;
  map<int, Noisy>::iterator it = nm.find(6);
  if(it != nm.end())
    cout << "warto:" << (*it).second
      << " znaleziona w kontenerze nm na pozycji 6" << endl;
  for(it = nm.begin(); it != nm.end(); it++)
    cout << (*it).first << ":"
      << (*it).second << ", ";
  cout << "\n-----------\n";
} ///:~
