
//: C06:NumStringGen.h
// Generator losowych wartoci zmiennoprzecinkowych reprezentowanych
// w postaci cigw znakowych
#ifndef NUMSTRINGGEN_H
#define NUMSTRINGGEN_H
#include <string>
#include <cstdlib>

class NumStringGen {
  const int sz; // Liczba cyfr
public:
  NumStringGen(int ssz = 5) : sz(ssz) {}
  std::string operator()() {
    std::string digits("0123456789");
    const int ndigits = digits.size();
    std::string r(sz, ' ');
    // Na pierwszej pozycji nie powinno by zera
    r[0] = digits[std::rand() % (ndigits - 1)] + 1;
    // Reszta cyfr
    for(int i = 1; i < sz; ++i)
      if(sz >= 3 && i == sz/2)
        r[i] = '.'; // Wstawienie kropki dziesitnej
      else
        r[i] = digits[std::rand() % ndigits];
    return r;
  }
};
#endif // NUMSTRINGGEN_H ///:~
