
//: C05:BearCorner2.cpp
// Pokazuje uycie klas polityki
#include <iostream>
#include "BearCorner.h"
using namespace std;

// Klasy polityki (wymagaj funkcji statycznej doAction()):
class Feed {
public:
  static const char* doAction() { return "je"; }
};

class Stuff {
public:
  static const char* doAction() { return "opycha si"; }
};

// Szablon Guest (korzysta z klas polityki i cech charakterystycznych)
template<class Guest, class Action,
         class traits = GuestTraits<Guest> >
class BearCorner {
  Guest theGuest;
  typedef typename traits::beverage_type beverage_type;
  typedef typename traits::snack_type snack_type;
  beverage_type bev;
  snack_type snack;
public:
  BearCorner(const Guest& g) : theGuest(g) {}
  void entertain() {
    cout << theGuest << " " << Action::doAction()
         << ": " << bev
         << " i " << snack << endl;
  }
};

int main() {
  Boy cr;
  BearCorner<Boy, Feed> pc1(cr);
  pc1.entertain();
  Bear pb;
  BearCorner<Bear, Stuff> pc2(pb);
  pc2.entertain();
} ///:~
