
//: C10:BeeAndFlowers.cpp
// Demonstracja wzorca Wizytator
#include <algorithm>
#include <iostream>
#include <string>
#include <vector>
#include <ctime>
#include <cstdlib>
#include "../purge.h"
using namespace std;

class Gladiolus;
class Renuculus;
class Chrysanthemum;

class Visitor {
public:
  virtual void visit(Gladiolus* f) = 0;
  virtual void visit(Renuculus* f) = 0;
  virtual void visit(Chrysanthemum* f) = 0;
  virtual ~Visitor() {}
};

class Flower {
public:
  virtual void accept(Visitor&) = 0;
  virtual ~Flower() {}
};

class Gladiolus : public Flower {
public:
  virtual void accept(Visitor& v) {
    v.visit(this);
  }
};

class Renuculus : public Flower {
public:
  virtual void accept(Visitor& v) {
    v.visit(this);
  }
};

class Chrysanthemum : public Flower {
public:
  virtual void accept(Visitor& v) {
    v.visit(this);
  }
};

// Uzupenienie o moliwo generowania cigw:
class StringVal : public Visitor {
  string s;
public:
  operator const string&() { return s; }
  virtual void visit(Gladiolus*) {
    s = "Gladiola";
  }
  virtual void visit(Renuculus*) {
    s = "Storczyk";
  }
  virtual void visit(Chrysanthemum*) {
    s = "Chryzantema";
  }
};

// Uzupenienie o moliwo wykonywania "pszczelich" czynnoci:
class Bee : public Visitor {
public:
  virtual void visit(Gladiolus*) {
    cout << "Pszczoa i Gladiola" << endl;
  }
  virtual void visit(Renuculus*) {
    cout << "Pszczoa i Storczyk" << endl;
  }
  virtual void visit(Chrysanthemum*) {
    cout << "Pszczoa i Chryzantema" << endl;
  }
};

struct FlowerGen {
  Flower* operator()() {
    switch(rand() % 3) {
      default:
      case 0: return new Gladiolus;
      case 1: return new Renuculus;
      case 2: return new Chrysanthemum;
    }
  }
};

int main() {
  srand(time(0)); // Inicjalizacja generatora pseudolosowego
  vector<Flower*> v(10);
  generate(v.begin(), v.end(), FlowerGen());
  vector<Flower*>::iterator it;
  // Dziaa prawie tak jak po uzupenieniu wirtualnymi wywoaniami
  // generujcymi cigi z nazwami kwiatw
StringVal sval;
  for(it = v.begin(); it != v.end(); it++) {
    (*it)->accept(sval);
    cout << string(sval) << endl;
  }
  // "Pszczele" czynnoci na kwiatach:
  Bee bee;
  for(it = v.begin(); it != v.end(); it++)
    (*it)->accept(bee);
  purge(v);
} ///:~
