
//: C07:Valarray2.cpp
// Ilustracja manipulacji na wycinkach i maskach
//{-bor} {dmc}
#include "PrintValarray.h"
using namespace std;

int main() {
  int data[] = {1,2,3,4,5,6,7,8,9,10,11,12};
  valarray<int> v(data, 12);
  valarray<int> r1(v[slice(0, 4, 3)]);
  print("slice(0,4,3)", r1);
  // Wyodrbnienie wycinka elementw speniajcych warunek
  valarray<int> r2(v[v > 6]);
  print("elementy > 6", r2);
  // Podniesienie pierwszej kolumny do potgi
  v[slice(0, 4, 3)] *= valarray<int>(v[slice(0, 4, 3)]);
  print("po podniesieniu pierwszej kolumny v do potgi", v);
  // Powrt
  int idx[] = {1,4,7,10};
  valarray<int> save(idx, 4);
  v[slice(0, 4, 3)] = save;
  print("przywrcony v ", v);
  // Wyodrbnienie podzbioru dwuwymiarowego: {{1, 3, 5}, {7, 9, 11}}
  valarray<size_t> siz(2);
  siz[0] = 2;
  siz[1] = 3;
  valarray<size_t> gap(2);
  gap[0] = 6;
  gap[1] = 2;
  valarray<int> r3(v[gslice(0, siz, gap)]);
  print("wycinek dwuwymiarowy", r3);
  // Wyodrbnienie zbioru za porednictwem maski wartoci logicznych
  valarray<bool> mask(false, 5);
  mask[1] = mask[2] = mask[4] = true;
  valarray<int> r4(v[mask]);
  print("v[mask]", r4);
  // Wyodrbnienie podzbioru za porednictwem maski indeksowej (elementw typu size_t)
  size_t idx2[] = {2,2,3,6};
  valarray<size_t> mask2(idx2, 4);
  valarray<int> r5(v[mask2]);
  print("v[mask2]", r5);
  // Wykorzystanie maski indeksowej w przypisaniu
  valarray<char> text("pora na nas", 11);
  valarray<char> caps("PNN", 3);
  valarray<size_t> idx3(3);
  idx3[0] = 0;
  idx3[1] = 5;
  idx3[2] = 8;
  text[idx3] = caps;
  print("wielkimi literami", text);
} ///:~
