
//: C07:BasicSequenceOperations.cpp
// Operacje obsugiwane przez wszystkie
// kontenery sekwencyjne
#include <deque>
#include <iostream>
#include <list>
#include <vector>
using namespace std;

template<typename Container>
void print(Container& c, char* title = "") {
  cout << title << ':' << endl;
  if(c.empty()) {
    cout << "(pusty)" << endl;
    return;
  }
  typename Container::iterator it;
  for(it = c.begin(); it != c.end(); it++)
    cout << *it << " ";
  cout << endl;
  cout << "size() " << c.size()
    << " max_size() "<< c.max_size()
    << " front() " << c.front()
    << " back() " << c.back() << endl;
}

template<typename ContainerOfInt>
void basicOps(char* s) {
  cout << "------- " << s << " -------" << endl;
  typedef ContainerOfInt Ci;
  Ci c;
  print(c, "c po wywoaniu konstruktora domylnego");
  Ci c2(10, 1); // 10 elementw, wszystkie o wartoci 1
  print(c2, "c2 po wywoaniu konstruktora z argumentami (10,1)");
  int ia[] = { 1, 3, 5, 7, 9 };
  const int iasz = sizeof(ia)/sizeof(*ia);
  // Inicjalizacja iteratorami granicznymi sekwencji:
  Ci c3(ia, ia + iasz);
  print(c3, "c3 po wywoaniu konstruktora z argumentami (iter, iter)");
  Ci c4(c2); // konstruktor kopiujcy
  print(c4, "c4 po wywoaniu konstruktora kopiujcego z argumentem (c2)");
  c = c2; // operator przypisania
  print(c, "c po wykonaniu przypisania z argumentem c2");
  c.assign(10, 2); // 10 elementw, wszystkie o wartoci 2
  print(c, "c po wywoaniu assign(10, 2)");
  // Przypisanie z iteratorami granicznymi sekwencji:
  c.assign(ia, ia + iasz);
  print(c, "c po wywoaniu assign(iter, iter)");
  cout << "c i iteratory wsteczne:" << endl;
  typename Ci::reverse_iterator rit = c.rbegin();
  while(rit != c.rend())
    cout << *rit++ << " ";
  cout << endl;
  c.resize(4);
  print(c, "c po wywoaniu resize(4)");
  c.push_back(47);
  print(c, "c po wywoaniu push_back(47)");
  c.pop_back();
  print(c, "c po wywoaniu pop_back()");
  typename Ci::iterator it = c.begin();
  it++; it++;
  c.insert(it, 74);
  print(c, "c po wywoaniu insert(it, 74)");
  it = c.begin();
  it++;
  c.insert(it, 3, 96);
  print(c, "c po wywoaniu insert(it, 3, 96)");
  it = c.begin();
  it++;
  c.insert(it, c3.begin(), c3.end());
  print(c, "c po wywoaniu insert(it, c3.begin(), c3.end())");
  it = c.begin();
  it++;
  c.erase(it);
  print(c, "c po wywoaniu erase(it)");
  typename Ci::iterator it2 = it = c.begin();
  it++;
  it2++; it2++; it2++; it2++; it2++;
  c.erase(it, it2);
  print(c, "c po wywoaniu erase(it, it2)");
  c.swap(c2);
  print(c, "c po wywoaniu swap(c2)");
  c.clear();
  print(c, "c po wywoaniu clear()");
}

int main() {
  basicOps<vector<int> >("vector");
  basicOps<deque<int> >("deque");
  basicOps<list<int> >("list");
} ///:~
