
//: C06:NString.h
// "Ponumerowany cig", pamitajcy pierwotn kolejno
// wystpowania poszczeglnych sw
#ifndef NSTRING_H
#define NSTRING_H
#include <algorithm>
#include <iostream>
#include <string>
#include <utility>
#include <vector>

typedef std::pair<std::string, int> psi;

// Porwnanie wycznie pierwszych elementw
bool operator==(const psi& l, const psi& r) {
  return l.first == r.first;
}

class NString {
  std::string s;
  int thisOccurrence;
  // ledzenie liczby wystpie:
  typedef std::vector<psi> vp;
  typedef vp::iterator vpit;
  static vp words;
  void addString(const std::string& x) {
    psi p(x, 0);
    vpit it = std::find(words.begin(), words.end(), p);
    if(it != words.end())
      thisOccurrence = ++it->second;
    else {
      thisOccurrence = 0;
      words.push_back(p);
    }
  }
public:
  NString() : thisOccurrence(0) {}
  NString(const std::string& x) : s(x) {
    addString(x);
  }
  NString(const char* x) : s(x) {
    addString(x);
  }

  // Domylny operator operator= oraz
  // domylny konstruktor kopiujcy tutaj wystarcza
  friend std::ostream& operator<<(
    std::ostream& os, const NString& ns) {
    return os << ns.s << " ["
      << ns.thisOccurrence << "]";
  }

  // Potrzebne do sortowania. Uwaga: porwnywane s jedynie
  // cigi, nie liczby wystpie:
  friend bool
  operator<(const NString& l, const NString& r) {
    return l.s < r.s;
  }

  friend
  bool operator==(const NString& l, const NString& r) {
    return l.s == r.s;
  }

  // Do sortowania z uyciem szablonu predykatu greater:
  friend bool
  operator>(const NString& l, const NString& r) {
    return l.s > r.s;
  }

  // odwoanie do obiektu cigu:
  operator const std::string&() const {return s;}
};

// Przydzia statycznego obiektu skadowego. Normalnie alokacja
// powinna odbywa si w osobnym pliku kodu rdowego (tu tylko
// dla uproszczenia):
NString::vp NString::words;

#endif // NSTRING_H ///:~
