
//: C06:FunctionObjects.cpp
//{-bor}
// Program ilustrujcy zastosowanie i dziaanie wybranych szablonw obiektw
// funkcyjnych z biblioteki standardowej C++
#include <algorithm>
#include <cstdlib>
#include <ctime>
#include <functional>
#include <iostream>
#include <iterator>
#include <vector>
#include "Generators.h"
#include "PrintSequence.h"
using namespace std;

template<typename Contain, typename UnaryFunc>
void testUnary(Contain& source, Contain& dest,
  UnaryFunc f) {
  transform(source.begin(), source.end(),
    dest.begin(), f);
}

template<typename Contain1, typename Contain2,
  typename BinaryFunc>
void testBinary(Contain1& src1, Contain1& src2,
  Contain2& dest, BinaryFunc f) {
  transform(src1.begin(), src1.end(),
    src2.begin(), dest.begin(), f);
}

// Wykonanie wyraenia i jego "konwersja" do cigu, do instrukcji print:
#define T(EXPR) EXPR; print(r.begin(), r.end(), \
  "Po " #EXPR, " ");

// Testy logiczne:
#define B(EXPR) EXPR; print(br.begin(), br.end(), \
  "Po " #EXPR, " ");

// Generator losowych wartoci logicznych:
struct BRand {
  bool operator()() {
    return rand() % 2 == 0;
  }
};

int main() {
  const int sz = 10;
  const int max = 50;
  vector<int> x(sz), y(sz), r(sz);

  // Generator losowych liczb cakowitych:
  URandGen urg(max);
  srand(time(0));  //Losowo
  generate_n(x.begin(), sz, urg);
  generate_n(y.begin(), sz, urg);
  // Dodanie jedynki do zwrconych wartoci (unikanie dzielenia przez zero):
  transform(y.begin(), y.end(), y.begin(),
    bind2nd(plus<int>(), 1));

  // Zagwarantowanie rwnoci przynajmniej jednej pary elementw:
  x[0] = y[0];
  print(x.begin(), x.end(), "x", " ");
  print(y.begin(), y.end(), "y", " ");

  // Dla kadej pary elementw x i y wynik dziaania funktora umieszczany jest w r:
  T(testBinary(x, y, r, plus<int>()));
  T(testBinary(x, y, r, minus<int>()));
  T(testBinary(x, y, r, multiplies<int>()));
  T(testBinary(x, y, r, divides<int>()));
  T(testBinary(x, y, r, modulus<int>()));
  T(testUnary(x, r, negate<int>()));

  vector<bool> br(sz); // dla wynikw testw logicznych 
  B(testBinary(x, y, br, equal_to<int>()));
  B(testBinary(x, y, br, not_equal_to<int>()));
  B(testBinary(x, y, br, greater<int>()));
  B(testBinary(x, y, br, less<int>()));
  B(testBinary(x, y, br, greater_equal<int>()));
  B(testBinary(x, y, br, less_equal<int>()));
  B(testBinary(x, y, br,
    not2(greater_equal<int>())));
  B(testBinary(x,y,br,not2(less_equal<int>())));

  vector<bool> b1(sz), b2(sz);
  generate_n(b1.begin(), sz, BRand());
  generate_n(b2.begin(), sz, BRand());
  print(b1.begin(), b1.end(), "b1", " ");
  print(b2.begin(), b2.end(), "b2", " ");
  B(testBinary(b1, b2, br, logical_and<int>()));
  B(testBinary(b1, b2, br, logical_or<int>()));
  B(testUnary(b1, br, logical_not<int>()));
  B(testUnary(b1, br, not1(logical_not<int>())));

} ///:~
