
//: C05:PartialOrder2.cpp
// Pokazuje czciowe uporzdkowanie szablonw klas
#include <iostream>
using namespace std;

template<class T, class U> class C {
public:
  void f() {
    cout << "Szablon gwny\n";
  }
};

template<class U> class C<int, U> {
public:
  void f() {
    cout << "T == int\n";
  }
};

template<class T> class C<T, double> {
public:
  void f() {
    cout << "U == double\n";
  }
};

template<class T, class U> class C<T*, U> {
public:
  void f() {
    cout << "uyto T*\n";
  }
};

template<class T, class U> class C<T, U*> {
public:
  void f() {
    cout << "uyto U*\n";
  }
};

template<class T, class U> class C<T*, U*> {
public:
  void f() {
    cout << "uyto T* i U*\n";
  }
};

template<class T> class C<T, T> {
public:
  void f() {
    cout << "T == U\n";
  }
};

int main() {
  C<float, int>().f();    // 1: Szablon gwny
  C<int, float>().f();    // 2: T == int
  C<float, double>().f(); // 3: U == double
  C<float, float>().f();  // 4: T == U
  C<float*, float>().f(); // 5: uyto T* [T to float]
  C<float, float*>().f(); // 6: uyto U* [U to float]
  C<float*, int*>().f();  // 7: uyto T* i U* [float,int]

  // Ponisze wywoania s niejednoznaczne
//   8: C<int, int>().f();
//   9: C<double, double>().f();
//  10: C<float*, float*>().f();
//  11: C<int, int*>().f();
//  12: C<int*, int*>().f();
} ///:~
