
//: C04:Showerr.cpp
// Odkomentowuje miejsca powodujce bdy
#include <cstddef>
#include <cstdlib>
#include <cstdio>
#include <fstream>
#include <iostream>
#include <sstream>
#include <string>
#include "../require.h"
using namespace std;

const string usage =
  "uycie: showerr nazwapliku nrrozdzialu\n"
  "gdzie nazwapliku to plik rdowy C++\n"
  "za nrrozdziau to rozdzia zawierajcy dany plik.\n"
  "Znajduje wierszy wykomentowane za pomoc //! i usuwa\n"
  "komentarz doczajcy //(NR), gdzie NR jest numerem niepowtarzalnym\n"
  "we wszystkich plikach, dziki czemu mona sprawdzi,\n"
  "czy kompilator znajdzie bd.\n"
  "showerr /r\n"
  "zeruje licznik numerw nadawanych bdom.";

class Showerr {
  const int CHAP;
  const string MARKER, FNAME;
  // Plik z licznikiem numerw bdw:
  const string ERRNUM;
  // Plik z bdnymi wierszami:
  const string ERRFILE;
  stringstream edited; // edytowany plik
  int counter;
public:
  Showerr(const string& f, const string& en,
    const string& ef, int c) : FNAME(f), MARKER("//!"),
    ERRNUM(en), ERRFILE(ef), CHAP(c) { counter = 0; }
  void replaceErrors() {
    ifstream infile(FNAME.c_str());
    assure(infile, FNAME.c_str());
    ifstream count(ERRNUM.c_str());
    if(count) count >> counter;
    int linecount = 1;
    string buf;
    ofstream errlines(ERRFILE.c_str(), ios::app);
    assure(errlines, ERRFILE.c_str());
    while(getline(infile, buf)) {
      // Znajd znacznik na pocztku wiersza:
      size_t pos = buf.find(MARKER);
      if(pos != string::npos) {
        // Usu znacznik:
        buf.erase(pos, MARKER.size() + 1);
        // Docz licznik i informacj o bdzie
        ostringstream out;
        out << buf << " // (" << ++counter << ") "
            << "Rozdzia " << CHAP
            << " Plik: " << FNAME
            << " Wiersz " << linecount << endl;
        edited << out.str();
        errlines << out.str(); // Docz plik bdw
      }
      else
        edited << buf << "\n"; // Zwyke kopiowanie
      linecount++;
    }
  }
  void saveFiles() {
    ofstream outfile(FNAME.c_str()); // Nadpisuje
    assure(outfile, FNAME.c_str());
    outfile << edited.rdbuf();
    ofstream count(ERRNUM.c_str()); // Nadpisuje
    assure(count, ERRNUM.c_str());
    count << counter; // Zapamitaj nowy stan licznika
  }
};

int main(int argc, char* argv[]) {
  const string ERRCOUNT("../errnum.txt"),
    ERRFILE("../errlines.txt");
  requireMinArgs(argc, 1, usage.c_str());
  if(argv[1][0] == '/' || argv[1][0] == '-') {
    // Dopu inne przeczniki
    switch(argv[1][1]) {
      case 'r': case 'R':
        cout << "zeruj licznik" << endl;
        remove(ERRCOUNT.c_str()); // Usu pliki
        remove(ERRFILE.c_str());
        return EXIT_SUCCESS;
      default:
        cerr << usage << endl;
        return EXIT_FAILURE;
    }
  }
  if (argc == 3) {
    Showerr s(argv[1], ERRCOUNT, ERRFILE, atoi(argv[2]));
    s.replaceErrors();
    s.saveFiles();
  }
} ///:~
