
//: C04:Seeking.cpp
// Przeszukiwanie strumieni iostream
#include <cassert>
#include <cstddef>
#include <cstring>
#include <fstream>
#include "../require.h"
using namespace std;

int main() {
  const int STR_NUM = 5, STR_LEN = 40;
  char origData[STR_NUM][STR_LEN] = {
    "Poprzez miedz, poprzez ki,",
    "Poprzez lene cieki wskie,",
    "Kto dogoni psa, kto dogoni psa?",
    "Moe ty? Moe ty?",
    "Moe jednak ja!"
  };
  char readData[STR_NUM][STR_LEN] = { 0 };
  ofstream out("Poem.bin", ios::out | ios::binary);
  assure(out, "Poem.bin");
  for(int i = 0; i < STR_NUM; i++)
    out.write(origData[i], STR_LEN);
  out.close();
  ifstream in("Poem.bin", ios::in | ios::binary);
  assure(in, "Poem.bin");
  in.read(readData[0], STR_LEN);
  assert(strcmp(readData[0], "Poprzez miedz, poprzez ki,")
    == 0);
  // Odnajd -STR_LEN bajtw od koca pliku
  in.seekg(-STR_LEN, ios::end);
  in.read(readData[1], STR_LEN);
  assert(strcmp(readData[1], "Moe jednak ja!")
    == 0);
  // Szukanie bezwzgldne (podobne do operator[] w pliku)
  in.seekg(3 * STR_LEN);
  in.read(readData[2], STR_LEN);
  assert(strcmp(readData[2], "Moe ty? Moe ty?") == 0);
  // Szukaj wstecz od aktualnego pooenia
  in.seekg(-STR_LEN * 2, ios::cur);
  in.read(readData[3], STR_LEN);
  assert(strcmp(readData[3], "Kto dogoni psa, kto dogoni psa?") == 0);
  // Szukaj od pocztku pliku
  in.seekg(1 * STR_LEN, ios::beg);
  in.read(readData[4], STR_LEN);
  assert(strcmp(readData[4], "Poprzez lene cieki wskie,")
    == 0);
} ///:~
