
//: C08:CheckedCast2.cpp
// Wykorzystanie rzutowania dynamicznego RTTI
#include <vector>
#include "../purge.h"
#include "Security.h"
using namespace std;

int main() {
  vector<Security*> portfolio;
  portfolio.push_back(new Metal);
  portfolio.push_back(new Investment);
  portfolio.push_back(new Bond);
  portfolio.push_back(new Stock);
  for(vector<Security*>::iterator it =
       portfolio.begin();
       it != portfolio.end(); ++it) {
    Investment* cm = dynamic_cast<Investment*>(*it);
    if(cm)
      cm->special();
    else
      cout << "to nie jest klasa Investment" << endl;
  }
  cout << "rzutowanie ze wskanika poredniego:" << endl;
  Security* sp = new Metal;
  Investment* cp = dynamic_cast<Investment*>(sp);
  if(cp) cout << " klasa Investment" << endl;
  Metal* mp = dynamic_cast<Metal*>(sp);
  if(mp) cout << " i rwnoczenie klasa Metal!" << endl;
  purge(portfolio);
} ///:~
