
//: C07:ListVsSet.cpp
// Porwnanie wydajnoci kontenerw list i set
#include <algorithm>
#include <iostream>
#include <list>
#include <set>
#include <cstdlib>
#include <ctime>
#include "PrintContainer.h"
using namespace std;

class Obj {
  int a[20]; // Imitacja obszernego obiektu
  int val;
public:
  Obj() : val(rand() % 500) {}
  friend bool
  operator<(const Obj& a, const Obj& b) {
    return a.val < b.val;
  }
  friend bool
  operator==(const Obj& a, const Obj& b) {
    return a.val == b.val;
  }
  friend ostream&
  operator<<(ostream& os, const Obj& a) {
    return os << a.val;
  }
};

struct ObjGen {
  Obj operator()() { return Obj(); }
};

int main() {
  const int sz = 5000;
  srand(time(0));
  list<Obj> lo;
  clock_t ticks = clock();
  generate_n(back_inserter(lo), sz, ObjGen());
  lo.sort();
  lo.unique();
  cout << "Kontener list:" << clock() - ticks << endl;
  set<Obj> so;
  ticks = clock();
  generate_n(inserter(so, so.begin()),
    sz, ObjGen());
  cout << "Kontener set:" << clock() - ticks << endl;
  print(lo);
  print(so);
} ///:~
