
//: C06:Removing.cpp
// Algorytmy usuwajce
#include <algorithm>
#include <cctype>
#include <string>
#include "Generators.h"
#include "PrintSequence.h"
using namespace std;

struct IsUpper {
  bool operator()(char c) {
    return isupper(c);
  }
};

int main() {
  string v;
  v.resize(25);
  generate(v.begin(), v.end(), CharGen());
  print(v.begin(), v.end(), "oryginalny wektor v", "");
  // Tworzenie zbioru znakw w wektorze v:
  string us(v.begin(), v.end());
  sort(us.begin(), us.end());
  string::iterator it = us.begin(), cit = v.end(),
    uend = unique(us.begin(), us.end());
  // Usunicie wszystkiego:
  while(it != uend) {
    cit = remove(v.begin(), cit, *it);
    print(v.begin(), v.end(), "Kompletny wektor v", "");
    print(v.begin(), cit, "Obcity wektor v ", " ");
    cout << "Element usunite:\t" << *it
         << "\nNowy ostatni element:\t"
         << *cit << endl << endl;
    it++;
  }
  generate(v.begin(), v.end(), CharGen());
  print(v.begin(), v.end(), "v", "");
  cit = remove_if(v.begin(), v.end(), IsUpper());
  print(v.begin(), cit, "wektor v po wykonaniu remove_if z predykatem IsUpper", " ");
  // Wersje kopiujce remove i remove_if zostay pominite
  sort(v.begin(), cit);
  print(v.begin(), cit, "sorted", " ");
  string v2;
  v2.resize(cit - v.begin());
  unique_copy(v.begin(), cit, v2.begin());
  print(v2.begin(), v2.end(), "unique_copy", " ");
  // Takie samo dziaanie:
  cit = unique(v.begin(), cit, equal_to<char>());
  print(v.begin(), cit, "unique z predykatem equal_to<char>", " ");
} ///:~
