
//: C06:Generators.h
// Rne rodki wypeniania sekwencji
#ifndef GENERATORS_H
#define GENERATORS_H
#include <set>
#include <cstdlib>
#include <cstring>

// Generator kolejnych wartoci cigu arytmetycznego:
class SkipGen {
  int i;
  int skp;
public:
  SkipGen(int start = 0, int skip = 1)
    : i(start), skp(skip) {}
  int operator()() {
    int r = i;
    i += skp;
    return r;
  }
};

// Generuje niepowtarzajce si liczby losowe z zakresu od 0 do lim:
class URandGen {
  std::set<int> used;
  int limit;
public:
  URandGen(int lim) : limit(lim) {}
  int operator()() {
    while(true) {
      int i = int(rand()) % limit;
      if(used.find(i) == used.end()) {
        used.insert(i);
        return i;
      }
    }
  }
};

// Generuje losowe znaki:
class CharGen {
  static const char* source;
  static const int len;
public:
  char operator()() {
    return source[rand() % len];
  }
};
#endif // GENERATORS_H ///:~
