
//: C05:Urand.h
//{-bor}
// Losowe generowanie liczb bez powtrze
#ifndef URAND_H
#define URAND_H
#include <bitset>
#include <cstddef>
#include <cstdlib>
#include <ctime>
using std::size_t;
using std::bitset;

template<size_t UpperBound>
class Urand {
  bitset<UpperBound> used;
public:
  Urand() {
    srand(time(0));  // Losowo
  }
  size_t operator()(); // Funkcja "generator"
};

template<size_t UpperBound>
inline size_t Urand<UpperBound>::operator()() {
  if(used.count() == UpperBound)
    used.reset();  // i od nowa (wyczy bitset)
  size_t newval;
  while(used[newval = rand() % UpperBound])
    ; // a do znalezienia niepowtarzalnej wartoci
  used[newval] = true;
  return newval;
}
#endif // URAND_H ///:~
