
//: C05:MinTest.cpp
#include <cstring>
#include <iostream>
using std::strcmp;
using std::cout;
using std::endl;

template<typename T> const T& min(const T& a, const T& b) {
  return (a < b) ? a : b;
}
const char* min(const char* a, const char* b) {
  return (strcmp(a, b) < 0) ? a : b;
}
double min(double x, double y) {
  return (x < y) ? x : y;
}

int main() {
  const char *s2 = "mwi \"Ni-!\"", *s1 = "rycerze ktrzy";
  cout << min(1, 2) << endl;      // 1: 1 (szablon)
  cout << min(1.0, 2.0) << endl;  // 2: 1 (double)
  cout << min(1, 2.0) << endl;    // 3: 1 (double)
  cout << min(s1, s2) << endl;    // 4: rycerze ktrzy (const
                                  //                 char*)
  cout << min<>(s1, s2) << endl;  // 5: mwi "Ni-!"
                                  //    (szablon)
} ///:~
