
//: C04:Strfile.cpp
// Stream I/O with files
// Rnice midzy get() a getline()
#include <fstream>
#include <iostream>
#include "../require.h"
using namespace std;

int main() {
  const int SZ = 100; // Wielko bufora;
  cout << "Hello!" << endl;
  char buf[SZ];
  {
     ifstream in("Strfile.cpp", ios_base::binary); // odczyt
    assure(in, "Strfile.cpp"); // sprawd otwarcie
    ofstream out("Strfile.out", ios_base::binary); // zapis
    assure(out, "Strfile.out");
    int i = 1; // licznik wierszy

    // mniej wygodna obsuga wierszy wejciowych:
    while(in.get(buf, SZ)) { // pozostawia w danych wejciowych \n
      in.get(); // odrzu nastpny znak (\n)
      cout << buf << endl; // konieczne dodanie \n
      // pisanie do pliku jak przy standardowych operacjach we-wy
      out << i++ << ": " << buf << endl;
    }
  } // Destruktory spowoduj zamknicie in i out

  ifstream in("Strfile.out");
  assure(in, "Strfile.out");
  // wygodniejsza obsuga wierszy wejciowych
  while(in.getline(buf, SZ)) { // usuwa \n
    char* cp = buf;
    while(*cp != ':')
      cp++;
    cp += 2; // przejd ": "
    cout << cp << endl; // nadal trzeba doda \n
  }
} ///:~
