
//: C03:ExtractCode.cpp {-edg} {RunByHand}
// Pobiera z tekstu kod rdowy
#include <cassert>
#include <cstddef>
#include <cstdio>
#include <cstdlib>
#include <fstream>
#include <iostream>
#include <string>
using namespace std;
// Stary plik nagwkowy C spoza standardu, potrzebny do mkdir()
#if defined(__GNUC__) || defined(__MWERKS_)
#include <sys/stat.h>
#elif defined(__BORLANDC__) || defined(_MSC_VER) \
  || defined(__DMC__)
#include <direct.h>
#else
#error Compiler not supported
#endif

// Sprawd, czy katalog istnieje, prbujc
// otworzy w nim do pisania nowy plik
bool exists(string fname) {
  size_t len = fname.length();
  if(fname[len-1] != '/' && fname[len-1] != '\\')
    fname.append("/");
  fname.append("000.tmp");
  ofstream outf(fname.c_str());
  bool existFlag = outf;
  if (outf) {
    outf.close();
    remove(fname.c_str());
  }
  return existFlag;
}

int main(int argc, char* argv[]) {
  // Sprawd, czy podano nazw pliku wejciowego
  if(argc == 1) {
    cerr << "uycie: extractCode plik [katalog]\n";
    exit(EXIT_FAILURE);
  }
  // Sprawd, czy istnieje plik wejciowy
  ifstream inf(argv[1]);
  if(!inf) {
    cerr << "bd otwierania pliku: " << argv[1] << endl;
    exit(EXIT_FAILURE);
  }
  // Szukanie opcjonalnego katalogu na wyniki
  string root("./");  // domylnie to katalog biecy
  if(argc == 3) {
    // Sprawd, czy istnieje katalog na wyniki
    root = argv[2];
    if(!exists(root)) {
      cerr << "nie istnieje katalog: " << root << endl;
      exit(EXIT_FAILURE);
    }
    size_t rootLen = root.length();
    if(root[rootLen-1] != '/' && root[rootLen-1] != '\\')
      root.append("/");
  }
  // Czytanie pliku wejciowego wiersz po wierszu,
  // szukanie ogranicznikw kodu
  string line;
  bool inCode = false;
  bool printDelims = true;
  ofstream outf;
  while (getline(inf, line)) {
    size_t findDelim = line.find("//" "/:~");
    if(findDelim != string::npos) {
      // Wypisz ostatni wiersz i zamknij plik
      if (!inCode) {
        cerr << "Nieprawidowe wiersze\n";
        exit(EXIT_FAILURE);
      }
      assert(outf);
      if (printDelims)
        outf << line << endl;
      outf.close();
      inCode = false;
      printDelims = true;
    } else {
      findDelim = line.find("//" ":");
      if(findDelim == 0) {
        // Szukaj dyrektywy '!'
        if(line[3] == '!') {
          printDelims = false;
          ++findDelim;  // Aby wykluczy z nastpnego szukania '!'
        }
        // Jeli istnieje, pobierz nazw podkatalogu
        size_t startOfSubdir =
          line.find_first_not_of(" \t", findDelim+3);
        findDelim = line.find(':', startOfSubdir);
        if (findDelim == string::npos) {
          cerr << "brak nazwy pliku\n" << endl;
          exit(EXIT_FAILURE);
        }
        string subdir;
        if(findDelim > startOfSubdir)
          subdir = line.substr(startOfSubdir,
                               findDelim - startOfSubdir);
        // Pobierz nazw pliku (lepiej, aby bya jedna!)
        size_t startOfFile = findDelim + 1;
        size_t endOfFile =
          line.find_first_of(" \t", startOfFile);
        if(endOfFile == startOfFile) {
          cerr << "brak nazwy pliku\n";
          exit(EXIT_FAILURE);
        }
        // Mamy wszystkie kawaki - stwrz pen ciek
        string fullPath(root);
        if(subdir.length() > 0)
          fullPath.append(subdir).append("/");
        assert(fullPath[fullPath.length()-1] == '/');
        if (!exists(fullPath))
#ifdef __GNUC__
          mkdir(fullPath.c_str(), 0);  // Utwrz podkatalog
#else
          mkdir(fullPath.c_str());  // Utwrz podkatalog
#endif
        fullPath.append(line.substr(startOfFile,
                        endOfFile - startOfFile));
        outf.open(fullPath.c_str());
        if(!outf) {
          cerr << "bd przy otwieraniu " << fullPath
               << " do pisania\n";
          exit(EXIT_FAILURE);
        }
        inCode = true;
        cout << "Przetwarzanie " << fullPath << endl;
        if(printDelims)
          outf << line << endl;
      }
      else if(inCode) {
        assert(outf);
        outf << line << endl;  // Wypisanie rodkowego wiersza kodu
      }
    }
  }
  exit(EXIT_SUCCESS);
} ///:~
