
//: C02:MemCheck.cpp {O}
#include <cstdio>
#include <cstdlib>
#include <cassert>
#include <cstddef> 
#include "memcheck.h"
using namespace std;
#undef new

// Flagi globalne ustawiane w makrach MemCheck.h
bool traceFlag = true;
bool activeFlag = false;

namespace {

// Typ opisujcy fragment pamici
struct Info {
  void* ptr;
  const char* file;
  long line;
};

// Dane mapy pamici
const size_t MAXPTRS = 10000u;
Info memMap[MAXPTRS];
size_t nptrs = 0;

// Szukanie adresu w mapie
int findPtr(void* p) {
  for(size_t i = 0; i < nptrs; ++i)
    if(memMap[i].ptr == p)
      return i;
  return -1;
}

void delPtr(void* p) {
  int pos = findPtr(p);
  assert(pos >= 0);
  // Usu wskanik z mapy
  for(size_t i = pos; i < nptrs-1; ++i)
    memMap[i] = memMap[i+1];
  --nptrs;
}

// Dodatkowy typ do destruktora statycznego
struct Sentinel {
  ~Sentinel() {
    if(nptrs > 0) {
      printf("Wyciek pamici w:\n");
      for(size_t i = 0; i < nptrs; ++i)
        printf("\t%p (plik: %s, line %ld)\n",
          memMap[i].ptr, memMap[i].file, memMap[i].line);
    }
    else
      printf("Program nie powoduje wyciekw pamici!\n");
  }
};

// Statyczny obiekt dodatkowy
Sentinel s;

} // Koniec anonimowej przestrzeni nazw

// Przeciona wersja skalarna new
void*
operator new(size_t siz, const char* file, long line) {
  void* p = malloc(siz);
  if(activeFlag) {
    if(nptrs == MAXPTRS) {
      printf("zbyt maa mapa pamici (zwiksz MAXPTRS)\n");
      exit(1);
    }
    memMap[nptrs].ptr = p;
    memMap[nptrs].file = file;
    memMap[nptrs].line = line;
    ++nptrs;
  }
  if(traceFlag) {
    printf("Zaalokowano %u bajtw pod adresem %p ", siz, p);
    printf("(plik: %s, wiersz: %ld)\n", file, line);
  }
  return p;
}

// Nadpisany new tablicowy
void*
operator new[](size_t siz, const char* file, long line) {
  return operator new(siz, file, line);
}

// Nadpisane delete skalarne 
void operator delete(void* p) {
  if(findPtr(p) >= 0) {
    free(p);
    assert(nptrs > 0);
    delPtr(p);
    if(traceFlag)
      printf("Usunito pami spod adresu %p\n", p);
  }
  else if(!p && activeFlag)
    printf("Prba usunicia nieznanego wskanika: %p\n", p);
}

// Nadpisany delete tablicowy
void operator delete[](void* p) {
  operator delete(p);
} ///:~
