
//: C01:Wrapped.cpp
// Bezpieczne wskaniki atomowe
#include <iostream>
#include <cstddef> 
using namespace std;

// Uproszczone; w praktyce moe by wicej argumentw
template<class T, int sz = 1> class PWrap {
  T* ptr;
public:
  class RangeError {}; // Klasa wyjtku
  PWrap() {
    ptr = new T[sz];
    cout << "konstruktor PWrap" << endl;
  }
  ~PWrap() {
    delete [] ptr;
    cout << "destruktor PWrap" << endl;
  }
  T& operator[](int i) throw (RangeError) {
    if(i >= 0 && i < sz) return ptr[i];
    throw RangeError();
  }
};

class Cat {
public:
  Cat() { cout << "Cat()" << endl; }
  ~Cat() { cout << "~Cat()" << endl; }
  void g() {}
};

class Dog {
public:
  void* operator new[](size_t) {
    cout << "alokacja pamici na obiekt Dog" << endl;
    throw 47;
  }
  void operator delete[](void* p) {
    cout << "zwalnianie pamici obiektu Dog" << endl;
    ::operator delete[](p);
  }
};

class UseResources {
  PWrap<Cat, 3> cats;
  PWrap<Dog> dog;
public:
  UseResources() {
    cout << "UseResources()" << endl;
  }
  ~UseResources() {
    cout << "~UseResources()" << endl;
  }
  void f() { cats[1].g(); }
};

int main() {
  try {
    UseResources ur;
  } catch(int) {
    cout << "w procedurze obsugi wyjtkw" << endl;
  } catch(...) {
    cout << "we frazie catch(...)" << endl;
  }
} ///:~
