/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionmap.remote;

import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.function.Supplier;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.server.NetworkOptions;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.grid.sessionmap.config.SessionMapOptions;
import org.openqa.selenium.grid.web.Values;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Tracer;

public class RemoteSessionMap
extends SessionMap {
    private final HttpClient client;

    public RemoteSessionMap(Tracer tracer, HttpClient client) {
        super(tracer);
        this.client = Require.nonNull("HTTP client", client);
    }

    public static SessionMap create(Config config) {
        Tracer tracer = new LoggingOptions(config).getTracer();
        URI uri = new SessionMapOptions(config).getSessionMapUri();
        HttpClient.Factory clientFactory = new NetworkOptions(config).getHttpClientFactory(tracer);
        try {
            return new RemoteSessionMap(tracer, clientFactory.createClient(uri.toURL()));
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean isReady() {
        try {
            return this.client.execute(new HttpRequest(HttpMethod.GET, "/readyz")).isSuccessful();
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    @Override
    public boolean add(Session session) {
        Require.nonNull("Session", session);
        HttpRequest request = new HttpRequest(HttpMethod.POST, "/se/grid/session");
        request.setContent((Supplier)Contents.asJson(session));
        return (Boolean)this.makeRequest(request, (Type)((Object)Boolean.class));
    }

    @Override
    public Session get(SessionId id) {
        Require.nonNull("Session ID", id);
        Session session = (Session)this.makeRequest(new HttpRequest(HttpMethod.GET, "/se/grid/session/" + id), (Type)((Object)Session.class));
        if (session == null) {
            throw new NoSuchSessionException("Unable to find session with ID: " + id);
        }
        return session;
    }

    @Override
    public URI getUri(SessionId id) throws NoSuchSessionException {
        Require.nonNull("Session ID", id);
        URI value = (URI)this.makeRequest(new HttpRequest(HttpMethod.GET, "/se/grid/session/" + id + "/uri"), (Type)((Object)URI.class));
        if (value == null) {
            throw new NoSuchSessionException("Unable to find session with ID: " + id);
        }
        return value;
    }

    @Override
    public void remove(SessionId id) {
        Require.nonNull("Session ID", id);
        this.makeRequest(new HttpRequest(HttpMethod.DELETE, "/se/grid/session/" + id), (Type)((Object)Void.class));
    }

    private <T> T makeRequest(HttpRequest request, Type typeOfT) {
        HttpTracing.inject(this.tracer, this.tracer.getCurrentContext(), request);
        HttpResponse response = this.client.execute(request);
        return Values.get(response, typeOfT);
    }
}

