/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.data;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.grid.data.SlotMatcher;

public class DefaultSlotMatcher
implements SlotMatcher,
Serializable {
    private static final List<String> EXTENSION_CAPABILITIES_PREFIXES = Arrays.asList("goog:", "moz:", "ms:", "se:");

    @Override
    public boolean matches(Capabilities stereotype, Capabilities capabilities) {
        if (!this.initialMatch(stereotype, capabilities).booleanValue()) {
            return false;
        }
        if (!this.platformVersionMatch(stereotype, capabilities).booleanValue()) {
            return false;
        }
        if (!this.extensionCapabilitiesMatch(stereotype, capabilities).booleanValue()) {
            return false;
        }
        boolean browserNameMatch = capabilities.getBrowserName() == null || capabilities.getBrowserName().isEmpty() || Objects.equals(stereotype.getBrowserName(), capabilities.getBrowserName());
        boolean browserVersionMatch = capabilities.getBrowserVersion() == null || capabilities.getBrowserVersion().isEmpty() || Objects.equals(stereotype.getBrowserVersion(), capabilities.getBrowserVersion());
        boolean platformNameMatch = capabilities.getPlatformName() == null || Objects.equals((Object)stereotype.getPlatformName(), (Object)capabilities.getPlatformName()) || stereotype.getPlatformName() != null && stereotype.getPlatformName().is(capabilities.getPlatformName());
        return browserNameMatch && browserVersionMatch && platformNameMatch;
    }

    private Boolean initialMatch(Capabilities stereotype, Capabilities capabilities) {
        return stereotype.getCapabilityNames().stream().filter(name -> !name.contains(":")).filter(name -> !"platform".equalsIgnoreCase((String)name) && !"platformName".equalsIgnoreCase((String)name)).map(name -> {
            if (capabilities.getCapability((String)name) instanceof String) {
                return stereotype.getCapability((String)name).toString().equalsIgnoreCase(capabilities.getCapability((String)name).toString());
            }
            return capabilities.getCapability((String)name) == null || Objects.equals(stereotype.getCapability((String)name), capabilities.getCapability((String)name));
        }).reduce(Boolean::logicalAnd).orElse(false);
    }

    private Boolean platformVersionMatch(Capabilities stereotype, Capabilities capabilities) {
        return capabilities.getCapabilityNames().stream().filter(name -> name.contains("platformVersion")).map(platformVersionCapName -> Objects.equals(stereotype.getCapability((String)platformVersionCapName), capabilities.getCapability((String)platformVersionCapName))).reduce(Boolean::logicalAnd).orElse(true);
    }

    private Boolean extensionCapabilitiesMatch(Capabilities stereotype, Capabilities capabilities) {
        return stereotype.getCapabilityNames().stream().filter(name -> name.contains(":")).filter(name -> capabilities.asMap().containsKey(name)).filter(name -> EXTENSION_CAPABILITIES_PREFIXES.stream().noneMatch(name::contains)).map(name -> {
            if (capabilities.getCapability((String)name) instanceof String) {
                return stereotype.getCapability((String)name).toString().equalsIgnoreCase(capabilities.getCapability((String)name).toString());
            }
            return capabilities.getCapability((String)name) == null || Objects.equals(stereotype.getCapability((String)name), capabilities.getCapability((String)name));
        }).reduce(Boolean::logicalAnd).orElse(true);
    }
}

