/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v96.profiler.model;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v96.debugger.model.Location;
import org.openqa.selenium.json.JsonInput;

public class ConsoleProfileStarted {
    private final String id;
    private final Location location;
    private final Optional<String> title;

    public ConsoleProfileStarted(String id, Location location, Optional<String> title) {
        this.id = Objects.requireNonNull(id, "id is required");
        this.location = Objects.requireNonNull(location, "location is required");
        this.title = title;
    }

    public String getId() {
        return this.id;
    }

    public Location getLocation() {
        return this.location;
    }

    public Optional<String> getTitle() {
        return this.title;
    }

    private static ConsoleProfileStarted fromJson(JsonInput input) {
        String id = null;
        Location location = null;
        Optional<String> title = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "id": {
                    id = input.nextString();
                    continue block10;
                }
                case "location": {
                    location = (Location)input.read((Type)((Object)Location.class));
                    continue block10;
                }
                case "title": {
                    title = Optional.ofNullable(input.nextString());
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ConsoleProfileStarted(id, location, title);
    }
}

