/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v85.audits.model;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v85.audits.model.AffectedFrame;
import org.openqa.selenium.devtools.v85.audits.model.AffectedRequest;
import org.openqa.selenium.devtools.v85.audits.model.BlockedByResponseReason;
import org.openqa.selenium.json.JsonInput;

public class BlockedByResponseIssueDetails {
    private final AffectedRequest request;
    private final Optional<AffectedFrame> frame;
    private final BlockedByResponseReason reason;

    public BlockedByResponseIssueDetails(AffectedRequest request, Optional<AffectedFrame> frame, BlockedByResponseReason reason) {
        this.request = Objects.requireNonNull(request, "request is required");
        this.frame = frame;
        this.reason = Objects.requireNonNull(reason, "reason is required");
    }

    public AffectedRequest getRequest() {
        return this.request;
    }

    public Optional<AffectedFrame> getFrame() {
        return this.frame;
    }

    public BlockedByResponseReason getReason() {
        return this.reason;
    }

    private static BlockedByResponseIssueDetails fromJson(JsonInput input) {
        AffectedRequest request = null;
        Optional<AffectedFrame> frame = Optional.empty();
        BlockedByResponseReason reason = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "request": {
                    request = (AffectedRequest)input.read((Type)((Object)AffectedRequest.class));
                    continue block10;
                }
                case "frame": {
                    frame = Optional.ofNullable((AffectedFrame)input.read((Type)((Object)AffectedFrame.class)));
                    continue block10;
                }
                case "reason": {
                    reason = (BlockedByResponseReason)((Object)input.read((Type)((Object)BlockedByResponseReason.class)));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new BlockedByResponseIssueDetails(request, frame, reason);
    }
}

