/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import java.util.Map;
import java.util.function.BiFunction;

final class MetricStorageUtils {
    static final int MAX_ACCUMULATIONS = 2000;

    private MetricStorageUtils() {
    }

    static <T> void mergeInPlace(Map<Attributes, T> result, Map<Attributes, T> toMerge, Aggregator<T> aggregator) {
        MetricStorageUtils.blend(result, toMerge, aggregator::merge);
    }

    static <T> void diffInPlace(Map<Attributes, T> result, Map<Attributes, T> toDiff, Aggregator<T> aggregator) {
        MetricStorageUtils.blend(result, toDiff, aggregator::diff);
    }

    private static <T> void blend(Map<Attributes, T> result, Map<Attributes, T> toMerge, BiFunction<T, T, T> blendFunction) {
        result.entrySet().removeIf(entry -> !toMerge.containsKey(entry.getKey()));
        toMerge.forEach((k, v) -> result.compute((Attributes)k, (k2, v2) -> v2 != null ? blendFunction.apply(v2, v) : v));
    }
}

