/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.data.ExponentialHistogramData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.exemplar.ExemplarReservoir;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.internal.aggregator.DoubleExponentialHistogramBuckets;
import io.opentelemetry.sdk.metrics.internal.aggregator.ExponentialHistogramAccumulation;
import io.opentelemetry.sdk.metrics.internal.aggregator.MetricDataUtils;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.resources.Resource;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

final class DoubleExponentialHistogramAggregator
implements Aggregator<ExponentialHistogramAccumulation> {
    private final Supplier<ExemplarReservoir> reservoirSupplier;

    DoubleExponentialHistogramAggregator(Supplier<ExemplarReservoir> reservoirSupplier) {
        this.reservoirSupplier = reservoirSupplier;
    }

    @Override
    public AggregatorHandle<ExponentialHistogramAccumulation> createHandle() {
        return new Handle(this.reservoirSupplier.get());
    }

    @Override
    public ExponentialHistogramAccumulation merge(ExponentialHistogramAccumulation previousAccumulation, ExponentialHistogramAccumulation delta) {
        double sum = previousAccumulation.getSum() + delta.getSum();
        long zeroCount = previousAccumulation.getZeroCount() + delta.getZeroCount();
        DoubleExponentialHistogramBuckets posBuckets = DoubleExponentialHistogramBuckets.merge(previousAccumulation.getPositiveBuckets(), delta.getPositiveBuckets());
        DoubleExponentialHistogramBuckets negBuckets = DoubleExponentialHistogramBuckets.merge(previousAccumulation.getNegativeBuckets(), delta.getNegativeBuckets());
        int commonScale = Math.min(posBuckets.getScale(), negBuckets.getScale());
        posBuckets.downscale(posBuckets.getScale() - commonScale);
        negBuckets.downscale(negBuckets.getScale() - commonScale);
        return ExponentialHistogramAccumulation.create(posBuckets.getScale(), sum, posBuckets, negBuckets, zeroCount, delta.getExemplars());
    }

    @Override
    public ExponentialHistogramAccumulation diff(ExponentialHistogramAccumulation previousCumulative, ExponentialHistogramAccumulation currentCumulative) {
        double sum = currentCumulative.getSum() - previousCumulative.getSum();
        long zeroCount = currentCumulative.getZeroCount() - previousCumulative.getZeroCount();
        DoubleExponentialHistogramBuckets posBuckets = DoubleExponentialHistogramBuckets.diff(currentCumulative.getPositiveBuckets(), previousCumulative.getPositiveBuckets());
        DoubleExponentialHistogramBuckets negBuckets = DoubleExponentialHistogramBuckets.diff(currentCumulative.getNegativeBuckets(), previousCumulative.getNegativeBuckets());
        int commonScale = Math.min(posBuckets.getScale(), negBuckets.getScale());
        posBuckets.downscale(posBuckets.getScale() - commonScale);
        negBuckets.downscale(negBuckets.getScale() - commonScale);
        return ExponentialHistogramAccumulation.create(posBuckets.getScale(), sum, posBuckets, negBuckets, zeroCount, currentCumulative.getExemplars());
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationLibraryInfo instrumentationLibrary, MetricDescriptor metricDescriptor, Map<Attributes, ExponentialHistogramAccumulation> accumulationByLabels, AggregationTemporality temporality, long startEpochNanos, long lastCollectionEpoch, long epochNanos) {
        return MetricData.createExponentialHistogram(resource, instrumentationLibrary, metricDescriptor.getName(), metricDescriptor.getDescription(), metricDescriptor.getUnit(), ExponentialHistogramData.create(temporality, MetricDataUtils.toExponentialHistogramPointList(accumulationByLabels, temporality == AggregationTemporality.CUMULATIVE ? startEpochNanos : lastCollectionEpoch, epochNanos)));
    }

    static final class Handle
    extends AggregatorHandle<ExponentialHistogramAccumulation> {
        private int scale = 20;
        private DoubleExponentialHistogramBuckets positiveBuckets = new DoubleExponentialHistogramBuckets();
        private DoubleExponentialHistogramBuckets negativeBuckets = new DoubleExponentialHistogramBuckets();
        private long zeroCount = 0L;
        private double sum = 0.0;

        Handle(ExemplarReservoir reservoir) {
            super(reservoir);
        }

        @Override
        protected synchronized ExponentialHistogramAccumulation doAccumulateThenReset(List<ExemplarData> exemplars) {
            ExponentialHistogramAccumulation acc = ExponentialHistogramAccumulation.create(this.scale, this.sum, this.positiveBuckets, this.negativeBuckets, this.zeroCount, exemplars);
            this.sum = 0.0;
            this.zeroCount = 0L;
            this.positiveBuckets = new DoubleExponentialHistogramBuckets();
            this.negativeBuckets = new DoubleExponentialHistogramBuckets();
            return acc;
        }

        @Override
        protected synchronized void doRecordDouble(double value) {
            DoubleExponentialHistogramBuckets buckets;
            if (!Double.isFinite(value)) {
                return;
            }
            this.sum += value;
            int c = Double.compare(value, 0.0);
            if (c == 0) {
                ++this.zeroCount;
                return;
            }
            DoubleExponentialHistogramBuckets doubleExponentialHistogramBuckets = buckets = c > 0 ? this.positiveBuckets : this.negativeBuckets;
            if (!buckets.record(value)) {
                this.downScale(buckets.getScaleReduction(value));
                buckets.record(value);
            }
        }

        @Override
        protected void doRecordLong(long value) {
            this.doRecordDouble(value);
        }

        void downScale(int by) {
            this.positiveBuckets.downscale(by);
            this.negativeBuckets.downscale(by);
            this.scale -= by;
        }
    }
}

