/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.netty.server;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.stream.ChunkedStream;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.InputStream;
import org.openqa.selenium.remote.http.HttpResponse;

public class ResponseConverter
extends ChannelOutboundHandlerAdapter {
    private static final int CHUNK_SIZE = 0x100000;
    private final boolean allowCors;

    public ResponseConverter(boolean allowCors) {
        this.allowCors = allowCors;
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!(msg instanceof HttpResponse)) {
            super.write(ctx, msg, promise);
            return;
        }
        HttpResponse seResponse = (HttpResponse)msg;
        byte[] ary = new byte[0x100000];
        InputStream is = (InputStream)seResponse.getContent().get();
        int byteCount = is.read(ary);
        int n = byteCount = byteCount == -1 ? 0 : byteCount;
        if (byteCount < 0x100000) {
            is.close();
            DefaultFullHttpResponse first = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf(seResponse.getStatus()), Unpooled.wrappedBuffer(ary, 0, byteCount));
            first.headers().addInt(HttpHeaderNames.CONTENT_LENGTH, byteCount);
            this.copyHeaders(seResponse, first);
            ctx.write(first);
        } else {
            DefaultHttpResponse first = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf(seResponse.getStatus()));
            first.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            this.copyHeaders(seResponse, first);
            ctx.write(first);
            ctx.write(new DefaultHttpContent(Unpooled.wrappedBuffer(ary)));
            HttpChunkedInput writer = new HttpChunkedInput(new ChunkedStream(is));
            ChannelFuture future = ctx.write(writer);
            future.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)ignored -> {
                is.close();
                ctx.flush();
            }));
        }
    }

    private void copyHeaders(HttpResponse seResponse, DefaultHttpResponse first) {
        for (String name : seResponse.getHeaderNames()) {
            if (HttpHeaderNames.CONTENT_LENGTH.contentEqualsIgnoreCase(name) || HttpHeaderNames.TRANSFER_ENCODING.contentEqualsIgnoreCase(name)) continue;
            for (String value : seResponse.getHeaders(name)) {
                if (value == null) continue;
                first.headers().add(name, (Object)value);
            }
        }
        if (this.allowCors) {
            first.headers().add("Access-Control-Allow-Origin", (Object)"*");
            first.headers().add("Access-Control-Allow-Methods", (Object)"GET,POST,DELETE");
            first.headers().add("Access-Control-Allow-Headers", (Object)"Accept,Content-Type");
        }
    }
}

