/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.graphql;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.grid.data.Availability;
import org.openqa.selenium.grid.data.NodeId;
import org.openqa.selenium.grid.data.Slot;
import org.openqa.selenium.grid.graphql.OsInfo;
import org.openqa.selenium.grid.graphql.Session;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;

public class Node {
    private static final Json JSON = new Json();
    private final NodeId id;
    private final URI uri;
    private final Availability status;
    private final int maxSession;
    private final Map<Capabilities, Integer> stereotypes;
    private final Map<org.openqa.selenium.grid.data.Session, Slot> activeSessions;
    private final String version;
    private final OsInfo osInfo;
    private final int slotCount;

    public Node(NodeId id, URI uri, Availability status, int maxSession, int slotCount, Map<Capabilities, Integer> stereotypes, Map<org.openqa.selenium.grid.data.Session, Slot> activeSessions, String version, OsInfo osInfo) {
        this.id = Require.nonNull("Node id", id);
        this.uri = Require.nonNull("Node uri", uri);
        this.status = status;
        this.maxSession = maxSession;
        this.slotCount = slotCount;
        this.stereotypes = Require.nonNull("Node stereotypes", stereotypes);
        this.activeSessions = Require.nonNull("Active sessions", activeSessions);
        this.version = Require.nonNull("Grid Node version", version);
        this.osInfo = Require.nonNull("Grid Node OS info", osInfo);
    }

    public List<Session> getSessions() {
        return this.activeSessions.entrySet().stream().map(this::createGraphqlSession).collect(ImmutableList.toImmutableList());
    }

    public int getSlotCount() {
        return this.slotCount;
    }

    public int getSessionCount() {
        return this.activeSessions.size();
    }

    public NodeId getId() {
        return this.id;
    }

    public URI getUri() {
        return this.uri;
    }

    public int getMaxSession() {
        return this.maxSession;
    }

    public List<String> getActiveSessionIds() {
        return this.activeSessions.keySet().stream().map(session -> session.getId().toString()).collect(ImmutableList.toImmutableList());
    }

    public String getStereotypes() {
        ArrayList toReturn = new ArrayList();
        for (Map.Entry<Capabilities, Integer> entry : this.stereotypes.entrySet()) {
            HashMap<String, Serializable> details = new HashMap<String, Serializable>();
            details.put("stereotype", entry.getKey());
            details.put("slots", entry.getValue());
            toReturn.add(details);
        }
        return JSON.toJson(toReturn);
    }

    public Availability getStatus() {
        return this.status;
    }

    public String getVersion() {
        return this.version;
    }

    public OsInfo getOsInfo() {
        return this.osInfo;
    }

    private Session createGraphqlSession(Map.Entry<org.openqa.selenium.grid.data.Session, Slot> entry) {
        org.openqa.selenium.grid.data.Session session = entry.getKey();
        Slot slot = entry.getValue();
        return new Session(session.getId().toString(), session.getCapabilities(), session.getStartTime(), session.getUri(), this.id.toString(), this.uri, slot);
    }
}

