/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v96.target;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v96.browser.model.BrowserContextID;
import org.openqa.selenium.devtools.v96.target.model.AttachedToTarget;
import org.openqa.selenium.devtools.v96.target.model.DetachedFromTarget;
import org.openqa.selenium.devtools.v96.target.model.ReceivedMessageFromTarget;
import org.openqa.selenium.devtools.v96.target.model.RemoteLocation;
import org.openqa.selenium.devtools.v96.target.model.SessionID;
import org.openqa.selenium.devtools.v96.target.model.TargetCrashed;
import org.openqa.selenium.devtools.v96.target.model.TargetID;
import org.openqa.selenium.devtools.v96.target.model.TargetInfo;

public class Target {
    public static Command<Void> activateTarget(TargetID targetId) {
        Objects.requireNonNull(targetId, "targetId is required");
        ImmutableMap.Builder<String, TargetID> params = ImmutableMap.builder();
        params.put("targetId", targetId);
        return new Command<Void>("Target.activateTarget", params.build());
    }

    public static Command<SessionID> attachToTarget(TargetID targetId, Optional<Boolean> flatten) {
        Objects.requireNonNull(targetId, "targetId is required");
        ImmutableMap.Builder<String, TargetID> params = ImmutableMap.builder();
        params.put("targetId", targetId);
        flatten.ifPresent(p -> params.put("flatten", (TargetID)p));
        return new Command<SessionID>("Target.attachToTarget", params.build(), ConverterFunctions.map("sessionId", SessionID.class));
    }

    @Beta
    public static Command<SessionID> attachToBrowserTarget() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<SessionID>("Target.attachToBrowserTarget", params.build(), ConverterFunctions.map("sessionId", SessionID.class));
    }

    public static Command<Boolean> closeTarget(TargetID targetId) {
        Objects.requireNonNull(targetId, "targetId is required");
        ImmutableMap.Builder<String, TargetID> params = ImmutableMap.builder();
        params.put("targetId", targetId);
        return new Command<Boolean>("Target.closeTarget", params.build(), ConverterFunctions.map("success", Boolean.class));
    }

    @Beta
    public static Command<Void> exposeDevToolsProtocol(TargetID targetId, Optional<String> bindingName) {
        Objects.requireNonNull(targetId, "targetId is required");
        ImmutableMap.Builder<String, TargetID> params = ImmutableMap.builder();
        params.put("targetId", targetId);
        bindingName.ifPresent(p -> params.put("bindingName", (TargetID)p));
        return new Command<Void>("Target.exposeDevToolsProtocol", params.build());
    }

    @Beta
    public static Command<BrowserContextID> createBrowserContext(Optional<Boolean> disposeOnDetach, Optional<String> proxyServer, Optional<String> proxyBypassList) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        disposeOnDetach.ifPresent(p -> params.put("disposeOnDetach", p));
        proxyServer.ifPresent(p -> params.put("proxyServer", p));
        proxyBypassList.ifPresent(p -> params.put("proxyBypassList", p));
        return new Command<BrowserContextID>("Target.createBrowserContext", params.build(), ConverterFunctions.map("browserContextId", BrowserContextID.class));
    }

    @Beta
    public static Command<List<BrowserContextID>> getBrowserContexts() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<List<BrowserContextID>>("Target.getBrowserContexts", params.build(), ConverterFunctions.map("browserContextIds", new TypeToken<List<BrowserContextID>>(){}.getType()));
    }

    public static Command<TargetID> createTarget(String url, Optional<Integer> width, Optional<Integer> height, Optional<BrowserContextID> browserContextId, Optional<Boolean> enableBeginFrameControl, Optional<Boolean> newWindow, Optional<Boolean> background) {
        Objects.requireNonNull(url, "url is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("url", url);
        width.ifPresent(p -> params.put("width", (String)p));
        height.ifPresent(p -> params.put("height", (String)p));
        browserContextId.ifPresent(p -> params.put("browserContextId", (String)p));
        enableBeginFrameControl.ifPresent(p -> params.put("enableBeginFrameControl", (String)p));
        newWindow.ifPresent(p -> params.put("newWindow", (String)p));
        background.ifPresent(p -> params.put("background", (String)p));
        return new Command<TargetID>("Target.createTarget", params.build(), ConverterFunctions.map("targetId", TargetID.class));
    }

    public static Command<Void> detachFromTarget(Optional<SessionID> sessionId, Optional<TargetID> targetId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        sessionId.ifPresent(p -> params.put("sessionId", p));
        targetId.ifPresent(p -> params.put("targetId", p));
        return new Command<Void>("Target.detachFromTarget", params.build());
    }

    @Beta
    public static Command<Void> disposeBrowserContext(BrowserContextID browserContextId) {
        Objects.requireNonNull(browserContextId, "browserContextId is required");
        ImmutableMap.Builder<String, BrowserContextID> params = ImmutableMap.builder();
        params.put("browserContextId", browserContextId);
        return new Command<Void>("Target.disposeBrowserContext", params.build());
    }

    @Beta
    public static Command<TargetInfo> getTargetInfo(Optional<TargetID> targetId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        targetId.ifPresent(p -> params.put("targetId", p));
        return new Command<TargetInfo>("Target.getTargetInfo", params.build(), ConverterFunctions.map("targetInfo", TargetInfo.class));
    }

    public static Command<List<TargetInfo>> getTargets() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<List<TargetInfo>>("Target.getTargets", params.build(), ConverterFunctions.map("targetInfos", new TypeToken<List<TargetInfo>>(){}.getType()));
    }

    @Deprecated
    public static Command<Void> sendMessageToTarget(String message, Optional<SessionID> sessionId, Optional<TargetID> targetId) {
        Objects.requireNonNull(message, "message is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("message", message);
        sessionId.ifPresent(p -> params.put("sessionId", (String)p));
        targetId.ifPresent(p -> params.put("targetId", (String)p));
        return new Command<Void>("Target.sendMessageToTarget", params.build());
    }

    @Beta
    public static Command<Void> setAutoAttach(Boolean autoAttach, Boolean waitForDebuggerOnStart, Optional<Boolean> flatten) {
        Objects.requireNonNull(autoAttach, "autoAttach is required");
        Objects.requireNonNull(waitForDebuggerOnStart, "waitForDebuggerOnStart is required");
        ImmutableMap.Builder<String, Boolean> params = ImmutableMap.builder();
        params.put("autoAttach", autoAttach);
        params.put("waitForDebuggerOnStart", waitForDebuggerOnStart);
        flatten.ifPresent(p -> params.put("flatten", (Boolean)p));
        return new Command<Void>("Target.setAutoAttach", params.build());
    }

    @Beta
    public static Command<Void> autoAttachRelated(TargetID targetId, Boolean waitForDebuggerOnStart) {
        Objects.requireNonNull(targetId, "targetId is required");
        Objects.requireNonNull(waitForDebuggerOnStart, "waitForDebuggerOnStart is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("targetId", targetId);
        params.put("waitForDebuggerOnStart", waitForDebuggerOnStart);
        return new Command<Void>("Target.autoAttachRelated", params.build());
    }

    public static Command<Void> setDiscoverTargets(Boolean discover) {
        Objects.requireNonNull(discover, "discover is required");
        ImmutableMap.Builder<String, Boolean> params = ImmutableMap.builder();
        params.put("discover", discover);
        return new Command<Void>("Target.setDiscoverTargets", params.build());
    }

    @Beta
    public static Command<Void> setRemoteLocations(List<RemoteLocation> locations) {
        Objects.requireNonNull(locations, "locations is required");
        ImmutableMap.Builder<String, List<RemoteLocation>> params = ImmutableMap.builder();
        params.put("locations", locations);
        return new Command<Void>("Target.setRemoteLocations", params.build());
    }

    public static Event<AttachedToTarget> attachedToTarget() {
        return new Event<AttachedToTarget>("Target.attachedToTarget", input -> (AttachedToTarget)input.read((Type)((Object)AttachedToTarget.class)));
    }

    public static Event<DetachedFromTarget> detachedFromTarget() {
        return new Event<DetachedFromTarget>("Target.detachedFromTarget", input -> (DetachedFromTarget)input.read((Type)((Object)DetachedFromTarget.class)));
    }

    public static Event<ReceivedMessageFromTarget> receivedMessageFromTarget() {
        return new Event<ReceivedMessageFromTarget>("Target.receivedMessageFromTarget", input -> (ReceivedMessageFromTarget)input.read((Type)((Object)ReceivedMessageFromTarget.class)));
    }

    public static Event<TargetInfo> targetCreated() {
        return new Event<TargetInfo>("Target.targetCreated", ConverterFunctions.map("targetInfo", TargetInfo.class));
    }

    public static Event<TargetID> targetDestroyed() {
        return new Event<TargetID>("Target.targetDestroyed", ConverterFunctions.map("targetId", TargetID.class));
    }

    public static Event<TargetCrashed> targetCrashed() {
        return new Event<TargetCrashed>("Target.targetCrashed", input -> (TargetCrashed)input.read((Type)((Object)TargetCrashed.class)));
    }

    public static Event<TargetInfo> targetInfoChanged() {
        return new Event<TargetInfo>("Target.targetInfoChanged", ConverterFunctions.map("targetInfo", TargetInfo.class));
    }
}

