/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v95.accessibility;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.v95.accessibility.model.AXNode;
import org.openqa.selenium.devtools.v95.accessibility.model.AXNodeId;
import org.openqa.selenium.devtools.v95.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.v95.dom.model.NodeId;
import org.openqa.selenium.devtools.v95.page.model.FrameId;
import org.openqa.selenium.devtools.v95.runtime.model.RemoteObjectId;

@Beta
public class Accessibility {
    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Accessibility.disable", params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Accessibility.enable", params.build());
    }

    @Beta
    public static Command<List<AXNode>> getPartialAXTree(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId, Optional<Boolean> fetchRelatives) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        nodeId.ifPresent(p -> params.put("nodeId", p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", p));
        objectId.ifPresent(p -> params.put("objectId", p));
        fetchRelatives.ifPresent(p -> params.put("fetchRelatives", p));
        return new Command<List<AXNode>>("Accessibility.getPartialAXTree", params.build(), ConverterFunctions.map("nodes", new TypeToken<List<AXNode>>(){}.getType()));
    }

    @Beta
    public static Command<List<AXNode>> getFullAXTree(Optional<Integer> depth, Optional<Integer> max_depth, Optional<FrameId> frameId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        depth.ifPresent(p -> params.put("depth", p));
        max_depth.ifPresent(p -> params.put("max_depth", p));
        frameId.ifPresent(p -> params.put("frameId", p));
        return new Command<List<AXNode>>("Accessibility.getFullAXTree", params.build(), ConverterFunctions.map("nodes", new TypeToken<List<AXNode>>(){}.getType()));
    }

    @Beta
    public static Command<List<AXNode>> getChildAXNodes(AXNodeId id, Optional<FrameId> frameId) {
        Objects.requireNonNull(id, "id is required");
        ImmutableMap.Builder<String, AXNodeId> params = ImmutableMap.builder();
        params.put("id", id);
        frameId.ifPresent(p -> params.put("frameId", (AXNodeId)p));
        return new Command<List<AXNode>>("Accessibility.getChildAXNodes", params.build(), ConverterFunctions.map("nodes", new TypeToken<List<AXNode>>(){}.getType()));
    }

    @Beta
    public static Command<List<AXNode>> queryAXTree(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId, Optional<String> accessibleName, Optional<String> role) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        nodeId.ifPresent(p -> params.put("nodeId", p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", p));
        objectId.ifPresent(p -> params.put("objectId", p));
        accessibleName.ifPresent(p -> params.put("accessibleName", p));
        role.ifPresent(p -> params.put("role", p));
        return new Command<List<AXNode>>("Accessibility.queryAXTree", params.build(), ConverterFunctions.map("nodes", new TypeToken<List<AXNode>>(){}.getType()));
    }
}

