/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.events;

import com.google.common.collect.ImmutableList;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.devtools.idealized.runtime.model.RemoteObject;

public class ConsoleEvent {
    private final String type;
    private final Instant timestamp;
    private final List<Object> args;

    public ConsoleEvent(String type, Instant timestamp, Object ... args) {
        this.type = type;
        this.timestamp = timestamp;
        this.args = ImmutableList.copyOf(args);
    }

    public String getType() {
        return this.type;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public List<Object> getArgs() {
        return this.args;
    }

    public List<String> getMessages() {
        return this.args.stream().map(List.class::cast).map(lst -> lst.get(0)).map(RemoteObject.class::cast).map(RemoteObject::getValue).map(Object::toString).collect(Collectors.toList());
    }

    public String toString() {
        return String.format("%s [%s] %s", this.timestamp, this.type, Stream.of(this.args).map(String::valueOf).collect(Collectors.joining(", ")));
    }
}

