/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.validation;

import graphql.Internal;
import graphql.execution.NonNullableValueCoercedAsNullException;
import graphql.execution.ValuesResolver;
import graphql.language.Value;
import graphql.schema.CoercingParseValueException;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeVisitorStub;
import graphql.schema.InputValueWithState;
import graphql.schema.validation.SchemaValidationError;
import graphql.schema.validation.SchemaValidationErrorCollector;
import graphql.schema.validation.SchemaValidationErrorType;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import graphql.validation.ValidationUtil;

@Internal
public class AppliedDirectiveArgumentsAreValid
extends GraphQLTypeVisitorStub {
    private ValidationUtil validationUtil = new ValidationUtil();

    @Override
    public TraversalControl visitGraphQLDirective(GraphQLDirective directive, TraverserContext<GraphQLSchemaElement> context) {
        if (context.getParentNode() != null) {
            for (GraphQLArgument graphQLArgument : directive.getArguments()) {
                this.checkArgument(directive, graphQLArgument, context);
            }
        }
        return TraversalControl.CONTINUE;
    }

    private void checkArgument(GraphQLDirective directive, GraphQLArgument argument, TraverserContext<GraphQLSchemaElement> context) {
        if (!argument.hasSetValue()) {
            return;
        }
        GraphQLSchema schema = context.getVarFromParents(GraphQLSchema.class);
        SchemaValidationErrorCollector errorCollector = context.getVarFromParents(SchemaValidationErrorCollector.class);
        InputValueWithState argumentValue = argument.getArgumentValue();
        boolean invalid = false;
        if (argumentValue.isLiteral() && !this.validationUtil.isValidLiteralValue((Value)argumentValue.getValue(), argument.getType(), schema)) {
            invalid = true;
        } else if (argumentValue.isExternal() && !this.isValidExternalValue(schema, argumentValue.getValue(), argument.getType())) {
            invalid = true;
        }
        if (invalid) {
            String message = String.format("Invalid argument '%s' for applied directive of name '%s'", argument.getName(), directive.getName());
            errorCollector.addError(new SchemaValidationError(SchemaValidationErrorType.InvalidAppliedDirectiveArgument, message));
        }
    }

    private boolean isValidExternalValue(GraphQLSchema schema, Object externalValue, GraphQLInputType type) {
        try {
            ValuesResolver.externalValueToInternalValue(schema.getCodeRegistry().getFieldVisibility(), externalValue, type);
            return true;
        }
        catch (NonNullableValueCoercedAsNullException | CoercingParseValueException e) {
            return false;
        }
    }
}

