/*
 * Decompiled with CFR 0.152.
 */
package graphql.relay;

import graphql.Assert;
import graphql.PublicApi;
import graphql.com.google.common.collect.ImmutableList;
import graphql.relay.Connection;
import graphql.relay.Edge;
import graphql.relay.PageInfo;
import java.util.Collection;
import java.util.List;

@PublicApi
public class DefaultConnection<T>
implements Connection<T> {
    private final ImmutableList<Edge<T>> edges;
    private final PageInfo pageInfo;

    public DefaultConnection(List<Edge<T>> edges, PageInfo pageInfo) {
        this.edges = ImmutableList.copyOf((Collection)Assert.assertNotNull(edges, () -> "edges cannot be null"));
        this.pageInfo = Assert.assertNotNull(pageInfo, () -> "page info cannot be null");
    }

    @Override
    public List<Edge<T>> getEdges() {
        return this.edges;
    }

    @Override
    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    public String toString() {
        return "DefaultConnection{edges=" + this.edges + ", pageInfo=" + this.pageInfo + '}';
    }
}

