/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonException;

public class SessionId
implements Serializable {
    private final String opaqueKey;

    public SessionId(UUID uuid) {
        this(Require.nonNull("Session ID key", uuid).toString());
    }

    public SessionId(String opaqueKey) {
        this.opaqueKey = Require.nonNull("Session ID key", opaqueKey);
    }

    public String toString() {
        return this.opaqueKey;
    }

    public int hashCode() {
        return this.opaqueKey.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof SessionId && this.opaqueKey.equals(((SessionId)obj).opaqueKey);
    }

    private String toJson() {
        return this.opaqueKey;
    }

    private static SessionId fromJson(Object raw) {
        Map map;
        if (raw instanceof String) {
            return new SessionId(String.valueOf(raw));
        }
        if (raw instanceof Map && (map = (Map)raw).get("value") instanceof String) {
            return new SessionId(String.valueOf(map.get("value")));
        }
        throw new JsonException("Unable to coerce session id from " + raw);
    }
}

