/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.io.CharSource;
import com.google.common.io.CharStreams;
import com.google.common.io.FileBackedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.JsonOutput;
import org.openqa.selenium.remote.AcceptedW3CCapabilityKeys;
import org.openqa.selenium.remote.CapabilitiesUtils;
import org.openqa.selenium.remote.Dialect;

public class NewSessionPayload
implements Closeable {
    private static final Dialect DEFAULT_DIALECT = Dialect.OSS;
    private static final Predicate<String> ACCEPTED_W3C_PATTERNS = new AcceptedW3CCapabilityKeys();
    private final Json json = new Json();
    private final FileBackedOutputStream backingStore;
    private final ImmutableSet<Dialect> dialects;

    public static NewSessionPayload create(Capabilities caps) {
        return NewSessionPayload.create(ImmutableMap.of("desiredCapabilities", caps.asMap()));
    }

    public static NewSessionPayload create(Map<String, ?> source) {
        String json = new Json().toJson(Require.nonNull("Payload", source));
        return new NewSessionPayload(new StringReader(json));
    }

    public static NewSessionPayload create(Reader source) {
        return new NewSessionPayload(source);
    }

    private NewSessionPayload(Reader source) {
        int threshold = (int)Math.min(Integer.MAX_VALUE, Math.min(Runtime.getRuntime().freeMemory() / 5L, Runtime.getRuntime().maxMemory() / 10L));
        this.backingStore = new FileBackedOutputStream(threshold);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)this.backingStore, StandardCharsets.UTF_8);){
            CharStreams.copy(source, writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        ImmutableSet.Builder dialects = ImmutableSet.builder();
        try {
            if (this.getOss() != null) {
                dialects.add((Object)Dialect.OSS);
            }
            if (this.getAlwaysMatch() != null || this.getFirstMatches() != null) {
                dialects.add((Object)Dialect.W3C);
            }
            this.dialects = dialects.build();
            this.validate();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try {
            source.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void validate() throws IOException {
        Map<String, Object> alwaysMatch = this.getAlwaysMatch();
        if (alwaysMatch == null) {
            alwaysMatch = ImmutableMap.of();
        }
        Map<String, Object> always = alwaysMatch;
        Collection<Map<String, Object>> firsts = this.getFirstMatches();
        if (firsts == null) {
            firsts = ImmutableList.of(ImmutableMap.of());
        }
        if (firsts.isEmpty()) {
            throw new IllegalArgumentException("First match w3c capabilities is zero length");
        }
        firsts.stream().peek(map -> {
            Sets.SetView overlap = Sets.intersection(always.keySet(), map.keySet());
            if (!overlap.isEmpty()) {
                throw new IllegalArgumentException("Overlapping keys between w3c always and first match capabilities: " + overlap);
            }
        }).map(first -> {
            HashMap toReturn = new HashMap();
            toReturn.putAll(always);
            toReturn.putAll(first);
            return toReturn;
        }).peek(map -> {
            ImmutableSortedSet nullKeys = map.entrySet().stream().filter(entry -> entry.getValue() == null).map(Map.Entry::getKey).collect(ImmutableSortedSet.toImmutableSortedSet(Ordering.natural()));
            if (!nullKeys.isEmpty()) {
                throw new IllegalArgumentException("Null values found in w3c capabilities. Keys are: " + nullKeys);
            }
        }).peek(map -> {
            ImmutableSortedSet illegalKeys = map.keySet().stream().filter(ACCEPTED_W3C_PATTERNS.negate()).collect(ImmutableSortedSet.toImmutableSortedSet(Ordering.natural()));
            if (!illegalKeys.isEmpty()) {
                throw new IllegalArgumentException("Illegal key values seen in w3c capabilities: " + illegalKeys);
            }
        }).forEach(map -> {});
    }

    public void writeTo(Appendable appendable) throws IOException {
        try (JsonOutput json = new Json().newOutput(appendable);){
            json.beginObject();
            Map<String, Object> first = this.getOss();
            if (first == null) {
                first = this.stream().findFirst().orElse(new ImmutableCapabilities()).asMap();
            }
            HashMap<String, Object> ossFirst = new HashMap<String, Object>(first);
            json.name("desiredCapabilities");
            json.write(ossFirst);
            json.name("capabilities");
            json.beginObject();
            json.name("firstMatch");
            json.beginArray();
            this.getW3C().forEach(json::write);
            json.endArray();
            json.endObject();
            this.writeMetaData(json);
            json.endObject();
        }
    }

    private void writeMetaData(JsonOutput out) throws IOException {
        CharSource charSource = this.backingStore.asByteSource().asCharSource(StandardCharsets.UTF_8);
        try (BufferedReader reader = charSource.openBufferedStream();
             JsonInput input = this.json.newInput(reader);){
            input.beginObject();
            block18: while (input.hasNext()) {
                String name;
                switch (name = input.nextName()) {
                    case "capabilities": 
                    case "desiredCapabilities": 
                    case "requiredCapabilities": {
                        input.skipValue();
                        continue block18;
                    }
                }
                out.name(name);
                out.write(input.read((Type)((Object)Object.class)));
            }
        }
    }

    public Stream<Capabilities> stream() {
        try {
            Stream<Map<String, Object>> oss = Stream.of(this.getOss());
            Stream<Map<String, Object>> w3c = this.getW3C();
            return Stream.concat(oss, w3c).filter(Objects::nonNull).distinct().map(ImmutableCapabilities::new);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Set<Dialect> getDownstreamDialects() {
        return this.dialects.isEmpty() ? ImmutableSet.of(DEFAULT_DIALECT) : this.dialects;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> getMetadata() {
        ImmutableSet<String> ignoredMetadataKeys = ImmutableSet.of("capabilities", "desiredCapabilities");
        CharSource charSource = this.backingStore.asByteSource().asCharSource(StandardCharsets.UTF_8);
        try (BufferedReader reader = charSource.openBufferedStream();){
            JsonInput input = this.json.newInput(reader);
            try {
                ImmutableMap.Builder toReturn = ImmutableMap.builder();
                input.beginObject();
                while (input.hasNext()) {
                    String name = input.nextName();
                    if (ignoredMetadataKeys.contains(name)) {
                        input.skipValue();
                        continue;
                    }
                    Object value = input.read((Type)((Object)Object.class));
                    if (value == null) continue;
                    toReturn.put(name, value);
                }
                input.endObject();
                ImmutableMap<String, Object> immutableMap = toReturn.build();
                if (input != null) {
                    input.close();
                }
                return immutableMap;
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.backingStore.reset();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Map<String, Object> getOss() throws IOException {
        CharSource charSource = this.backingStore.asByteSource().asCharSource(StandardCharsets.UTF_8);
        try (BufferedReader reader = charSource.openBufferedStream();
             JsonInput input = this.json.newInput(reader);){
            input.beginObject();
            while (input.hasNext()) {
                String name = input.nextName();
                if ("desiredCapabilities".equals(name)) {
                    Map map = (Map)input.read(Json.MAP_TYPE);
                    return map;
                }
                input.skipValue();
            }
        }
        return null;
    }

    private Stream<Map<String, Object>> getW3C() throws IOException {
        Stream<Map> fromW3c;
        Map<String, Object> ossCapabilities = this.getOss();
        Stream<Map<String, Object>> fromOss = ossCapabilities != null ? CapabilitiesUtils.makeW3CSafe(ossCapabilities) : Stream.of(new Map[0]);
        Map<String, Object> alwaysMatch = this.getAlwaysMatch();
        Collection<Map<String, Object>> firsts = this.getFirstMatches();
        if (alwaysMatch == null && firsts == null) {
            fromW3c = Stream.of(new Map[0]);
        } else {
            if (alwaysMatch == null) {
                alwaysMatch = ImmutableMap.of();
            }
            Map<String, Object> always = alwaysMatch;
            if (firsts == null) {
                firsts = ImmutableList.of(ImmutableMap.of());
            }
            fromW3c = firsts.stream().map(first -> ImmutableMap.builder().putAll(always).putAll(first).build());
        }
        return Stream.concat(fromOss, fromW3c).distinct();
    }

    private Map<String, Object> getAlwaysMatch() throws IOException {
        CharSource charSource = this.backingStore.asByteSource().asCharSource(StandardCharsets.UTF_8);
        try (BufferedReader reader = charSource.openBufferedStream();
             JsonInput input = this.json.newInput(reader);){
            input.beginObject();
            while (input.hasNext()) {
                String name = input.nextName();
                if ("capabilities".equals(name)) {
                    input.beginObject();
                    while (input.hasNext()) {
                        name = input.nextName();
                        if ("alwaysMatch".equals(name)) {
                            Map map = (Map)input.read(Json.MAP_TYPE);
                            return map;
                        }
                        input.skipValue();
                    }
                    input.endObject();
                    continue;
                }
                input.skipValue();
            }
        }
        return null;
    }

    private Collection<Map<String, Object>> getFirstMatches() throws IOException {
        CharSource charSource = this.backingStore.asByteSource().asCharSource(StandardCharsets.UTF_8);
        try (BufferedReader reader = charSource.openBufferedStream();
             JsonInput input = this.json.newInput(reader);){
            input.beginObject();
            while (input.hasNext()) {
                String name = input.nextName();
                if ("capabilities".equals(name)) {
                    input.beginObject();
                    while (input.hasNext()) {
                        name = input.nextName();
                        if ("firstMatch".equals(name)) {
                            Collection collection = (Collection)input.read(Json.LIST_OF_MAPS_TYPE);
                            return collection;
                        }
                        input.skipValue();
                    }
                    input.endObject();
                    continue;
                }
                input.skipValue();
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        try {
            this.writeTo(res);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return res.toString();
    }
}

