/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import java.net.URL;
import java.util.logging.Logger;
import org.openqa.selenium.grid.web.ClassPathResource;
import org.openqa.selenium.grid.web.NoHandler;
import org.openqa.selenium.grid.web.ResourceHandler;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;

public class GridUiRoute
implements Routable {
    private static final Logger LOG = Logger.getLogger("selenium");
    private static final String GRID_RESOURCE = "javascript/grid-ui/build";
    private static final String GRID_RESOURCE_WITH_PREFIX = String.format("/%s", "javascript/grid-ui/build");
    private final Route routes;

    public GridUiRoute() {
        URL uiRoot = GridUiRoute.class.getResource(GRID_RESOURCE_WITH_PREFIX);
        if (uiRoot != null) {
            ResourceHandler uiHandler = new ResourceHandler(new ClassPathResource(uiRoot, GRID_RESOURCE));
            HttpResponse uiRedirect = (HttpResponse)new HttpResponse().setStatus(302).addHeader("Location", "/ui/index.html");
            this.routes = Route.combine(Route.get("/").to(() -> req -> uiRedirect), Route.get("/grid/console").to(() -> req -> uiRedirect), Route.prefix("/ui").to(Route.matching(req -> true).to(() -> uiHandler)));
        } else {
            LOG.warning("It was not possible to load the Grid UI.");
            Json json = new Json();
            this.routes = Route.matching(req -> false).to(() -> new NoHandler(json));
        }
    }

    @Override
    public boolean matches(HttpRequest req) {
        return this.routes.matches(req);
    }

    @Override
    public HttpResponse execute(HttpRequest req) {
        return this.routes.execute(req);
    }
}

