/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionmap.config;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.grid.sessionmap.SessionMap;

public class SessionMapOptions {
    private static final String SESSIONS_SECTION = "sessions";
    private static final String DEFAULT_SESSION_MAP = "org.openqa.selenium.grid.sessionmap.remote.RemoteSessionMap";
    private static final String DEFAULT_SESSION_MAP_SCHEME = "http";
    private final Config config;

    public SessionMapOptions(Config config) {
        this.config = config;
    }

    public URI getSessionMapUri() {
        String scheme = this.config.get(SESSIONS_SECTION, "scheme").orElse(DEFAULT_SESSION_MAP_SCHEME);
        Optional<URI> host = this.config.get(SESSIONS_SECTION, "host").map(str -> {
            try {
                URI sessionUri = new URI((String)str);
                if (sessionUri.getHost() == null || sessionUri.getPort() == -1) {
                    throw new ConfigException("Undefined host or port in SessionMap server URI: " + str, new Object[0]);
                }
                return sessionUri;
            }
            catch (URISyntaxException e) {
                throw new ConfigException("Session Map server URI is not a valid URI: " + str, new Object[0]);
            }
        });
        if (host.isPresent()) {
            return host.get();
        }
        Optional<Integer> port = this.config.getInt(SESSIONS_SECTION, "port");
        Optional<String> hostname = this.config.get(SESSIONS_SECTION, "hostname");
        if (!port.isPresent() || !hostname.isPresent()) {
            throw new ConfigException("Unable to determine host and port for the session map server", new Object[0]);
        }
        try {
            return new URI(scheme, null, hostname.get(), port.get(), "", null, null);
        }
        catch (URISyntaxException e) {
            throw new ConfigException("Session map server uri configured through host (%s) and port (%d) is not a valid URI", hostname.get(), port.get());
        }
    }

    public SessionMap getSessionMap() {
        return this.config.getClass(SESSIONS_SECTION, "implementation", SessionMap.class, DEFAULT_SESSION_MAP);
    }
}

