/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker;

import com.google.common.collect.ImmutableMap;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.openqa.selenium.docker.DockerProtocol;
import org.openqa.selenium.docker.Version;
import org.openqa.selenium.docker.v1_41.V141Docker;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class VersionCommand {
    private static final Json JSON = new Json();
    private static final Map<Version, Function<HttpHandler, DockerProtocol>> SUPPORTED_VERSIONS = ImmutableMap.of(new Version("1.40"), V141Docker::new);
    private final HttpHandler handler;

    public VersionCommand(HttpHandler handler) {
        this.handler = Require.nonNull("HTTP client", handler);
    }

    public Optional<DockerProtocol> getDockerProtocol() {
        try {
            HttpResponse res = this.handler.execute(new HttpRequest(HttpMethod.GET, "/version"));
            if (!res.isSuccessful()) {
                return Optional.empty();
            }
            Map raw = (Map)JSON.toType(Contents.string(res), Json.MAP_TYPE);
            Version maxVersion = new Version((String)raw.get("ApiVersion"));
            Version minVersion = new Version((String)raw.get("MinAPIVersion"));
            return SUPPORTED_VERSIONS.entrySet().stream().filter(entry -> {
                Version version = (Version)entry.getKey();
                if (version.equalTo(maxVersion) || version.equalTo(minVersion)) {
                    return true;
                }
                return version.isLessThan(maxVersion) && version.isGreaterThan(minVersion);
            }).map(Map.Entry::getValue).map(func -> (DockerProtocol)func.apply(this.handler)).findFirst();
        }
        catch (UncheckedIOException | ClassCastException | NullPointerException | JsonException e) {
            return Optional.empty();
        }
    }
}

