/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v96.systeminfo.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum ImageType {
    JPEG("jpeg"),
    WEBP("webp"),
    UNKNOWN("unknown");

    private String value;

    private ImageType(String value) {
        this.value = value;
    }

    public static ImageType fromString(String s2) {
        return Arrays.stream(ImageType.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within ImageType "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static ImageType fromJson(JsonInput input) {
        return ImageType.fromString(input.nextString());
    }
}

