/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v95.memory.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum PressureLevel {
    MODERATE("moderate"),
    CRITICAL("critical");

    private String value;

    private PressureLevel(String value) {
        this.value = value;
    }

    public static PressureLevel fromString(String s2) {
        return Arrays.stream(PressureLevel.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within PressureLevel "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static PressureLevel fromJson(JsonInput input) {
        return PressureLevel.fromString(input.nextString());
    }
}

