/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v85.network.model;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v85.network.model.BlockedSetCookieWithReason;
import org.openqa.selenium.devtools.v85.network.model.Headers;
import org.openqa.selenium.devtools.v85.network.model.RequestId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class ResponseReceivedExtraInfo {
    private final RequestId requestId;
    private final List<BlockedSetCookieWithReason> blockedCookies;
    private final Headers headers;
    private final Optional<String> headersText;

    public ResponseReceivedExtraInfo(RequestId requestId, List<BlockedSetCookieWithReason> blockedCookies, Headers headers, Optional<String> headersText) {
        this.requestId = Objects.requireNonNull(requestId, "requestId is required");
        this.blockedCookies = Objects.requireNonNull(blockedCookies, "blockedCookies is required");
        this.headers = Objects.requireNonNull(headers, "headers is required");
        this.headersText = headersText;
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public List<BlockedSetCookieWithReason> getBlockedCookies() {
        return this.blockedCookies;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public Optional<String> getHeadersText() {
        return this.headersText;
    }

    private static ResponseReceivedExtraInfo fromJson(JsonInput input) {
        RequestId requestId = null;
        List blockedCookies = null;
        Headers headers = null;
        Optional<String> headersText = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "requestId": {
                    requestId = (RequestId)input.read((Type)((Object)RequestId.class));
                    continue block12;
                }
                case "blockedCookies": {
                    blockedCookies = (List)input.read(new TypeToken<List<BlockedSetCookieWithReason>>(){}.getType());
                    continue block12;
                }
                case "headers": {
                    headers = (Headers)input.read((Type)((Object)Headers.class));
                    continue block12;
                }
                case "headersText": {
                    headersText = Optional.ofNullable(input.nextString());
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ResponseReceivedExtraInfo(requestId, blockedCookies, headers, headersText);
    }
}

