/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.view;

import com.google.auto.value.AutoValue;
import io.opentelemetry.sdk.metrics.internal.view.StringPredicates;
import io.opentelemetry.sdk.metrics.view.AutoValue_MeterSelector;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
public abstract class MeterSelector {
    public static Builder builder() {
        return new AutoValue_MeterSelector.Builder().setNameFilter(StringPredicates.ALL).setVersionFilter(StringPredicates.ALL).setSchemaUrlFilter(StringPredicates.ALL);
    }

    public abstract Predicate<String> getNameFilter();

    public abstract Predicate<String> getVersionFilter();

    public abstract Predicate<String> getSchemaUrlFilter();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setNameFilter(Predicate<String> var1);

        public final Builder setNamePattern(Pattern pattern) {
            return this.setNameFilter(StringPredicates.regex(pattern));
        }

        public final Builder setName(String name) {
            return this.setNameFilter(StringPredicates.exact(name));
        }

        public abstract Builder setVersionFilter(Predicate<String> var1);

        public final Builder setVersionPattern(Pattern pattern) {
            return this.setVersionFilter(StringPredicates.regex(pattern));
        }

        public final Builder setVersion(String version) {
            return this.setVersionFilter(StringPredicates.exact(version));
        }

        abstract Builder setSchemaUrlFilter(Predicate<String> var1);

        public final Builder setSchemaUrlPattern(Pattern pattern) {
            return this.setSchemaUrlFilter(StringPredicates.regex(pattern));
        }

        public final Builder setSchemaUrl(String url) {
            return this.setSchemaUrlFilter(StringPredicates.exact(url));
        }

        public abstract MeterSelector build();
    }
}

