/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.data;

import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.data.Data;
import io.opentelemetry.sdk.metrics.data.DoubleExponentialHistogramData;
import io.opentelemetry.sdk.metrics.data.DoubleGaugeData;
import io.opentelemetry.sdk.metrics.data.DoubleHistogramData;
import io.opentelemetry.sdk.metrics.data.DoubleSumData;
import io.opentelemetry.sdk.metrics.data.DoubleSummaryData;
import io.opentelemetry.sdk.metrics.data.ExponentialHistogramData;
import io.opentelemetry.sdk.metrics.data.LongGaugeData;
import io.opentelemetry.sdk.metrics.data.LongSumData;
import io.opentelemetry.sdk.metrics.data.MetricDataImpl;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import io.opentelemetry.sdk.resources.Resource;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface MetricData {
    public static MetricData createDoubleGauge(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, String name, String description, String unit, DoubleGaugeData data) {
        return MetricDataImpl.create(resource, instrumentationLibraryInfo, name, description, unit, MetricDataType.DOUBLE_GAUGE, data);
    }

    public static MetricData createLongGauge(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, String name, String description, String unit, LongGaugeData data) {
        return MetricDataImpl.create(resource, instrumentationLibraryInfo, name, description, unit, MetricDataType.LONG_GAUGE, data);
    }

    public static MetricData createDoubleSum(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, String name, String description, String unit, DoubleSumData data) {
        return MetricDataImpl.create(resource, instrumentationLibraryInfo, name, description, unit, MetricDataType.DOUBLE_SUM, data);
    }

    public static MetricData createLongSum(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, String name, String description, String unit, LongSumData data) {
        return MetricDataImpl.create(resource, instrumentationLibraryInfo, name, description, unit, MetricDataType.LONG_SUM, data);
    }

    public static MetricData createDoubleSummary(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, String name, String description, String unit, DoubleSummaryData data) {
        return MetricDataImpl.create(resource, instrumentationLibraryInfo, name, description, unit, MetricDataType.SUMMARY, data);
    }

    public static MetricData createDoubleHistogram(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, String name, String description, String unit, DoubleHistogramData data) {
        return MetricDataImpl.create(resource, instrumentationLibraryInfo, name, description, unit, MetricDataType.HISTOGRAM, data);
    }

    public static MetricData createExponentialHistogram(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, String name, String description, String unit, ExponentialHistogramData data) {
        return MetricDataImpl.create(resource, instrumentationLibraryInfo, name, description, unit, MetricDataType.EXPONENTIAL_HISTOGRAM, data);
    }

    public Resource getResource();

    public InstrumentationLibraryInfo getInstrumentationLibraryInfo();

    public String getName();

    public String getDescription();

    public String getUnit();

    public MetricDataType getType();

    public Data<?> getData();

    default public boolean isEmpty() {
        return this.getData().getPoints().isEmpty();
    }

    default public DoubleGaugeData getDoubleGaugeData() {
        if (this.getType() == MetricDataType.DOUBLE_GAUGE) {
            return (DoubleGaugeData)this.getData();
        }
        return DoubleGaugeData.EMPTY;
    }

    default public LongGaugeData getLongGaugeData() {
        if (this.getType() == MetricDataType.LONG_GAUGE) {
            return (LongGaugeData)this.getData();
        }
        return LongGaugeData.EMPTY;
    }

    default public DoubleSumData getDoubleSumData() {
        if (this.getType() == MetricDataType.DOUBLE_SUM) {
            return (DoubleSumData)this.getData();
        }
        return DoubleSumData.EMPTY;
    }

    default public LongSumData getLongSumData() {
        if (this.getType() == MetricDataType.LONG_SUM) {
            return (LongSumData)this.getData();
        }
        return LongSumData.EMPTY;
    }

    default public DoubleSummaryData getDoubleSummaryData() {
        if (this.getType() == MetricDataType.SUMMARY) {
            return (DoubleSummaryData)this.getData();
        }
        return DoubleSummaryData.EMPTY;
    }

    default public DoubleHistogramData getDoubleHistogramData() {
        if (this.getType() == MetricDataType.HISTOGRAM) {
            return (DoubleHistogramData)this.getData();
        }
        return DoubleHistogramData.EMPTY;
    }

    default public ExponentialHistogramData getExponentialHistogramData() {
        if (this.getType() == MetricDataType.EXPONENTIAL_HISTOGRAM) {
            return (ExponentialHistogramData)this.getData();
        }
        return DoubleExponentialHistogramData.EMPTY;
    }
}

