/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.config;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.openqa.selenium.grid.config.Config;

class ClassCreation {
    private ClassCreation() {
    }

    static <X> X callCreateMethod(String clazz, Class<X> typeOfClass, Config configToUse) throws ReflectiveOperationException {
        Class<?> classClazz = Class.forName(clazz, true, Thread.currentThread().getContextClassLoader());
        try {
            Method create = classClazz.getMethod("create", Config.class);
            if (!Modifier.isStatic(create.getModifiers())) {
                throw new IllegalArgumentException(String.format("Class %s's `create(Config)` method must be static", clazz));
            }
            if (!typeOfClass.isAssignableFrom(create.getReturnType())) {
                throw new IllegalArgumentException(String.format("Class %s's `create(Config)` method must be static", clazz));
            }
            return typeOfClass.cast(create.invoke(null, configToUse));
        }
        catch (NoSuchMethodException e) {
            Constructor<X> constructor;
            try {
                constructor = classClazz.asSubclass(typeOfClass).getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e2) {
                throw new IllegalArgumentException(String.format("Class %s must have a static `create(Config)` method or a default constructor", clazz));
            }
            return constructor.newInstance(new Object[0]);
        }
    }
}

