/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v94.fetch.model;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public class AuthChallengeResponse {
    private final Response response;
    private final Optional<String> username;
    private final Optional<String> password;

    public AuthChallengeResponse(Response response, Optional<String> username, Optional<String> password) {
        this.response = Objects.requireNonNull(response, "response is required");
        this.username = username;
        this.password = password;
    }

    public Response getResponse() {
        return this.response;
    }

    public Optional<String> getUsername() {
        return this.username;
    }

    public Optional<String> getPassword() {
        return this.password;
    }

    private static AuthChallengeResponse fromJson(JsonInput input) {
        Response response = null;
        Optional<String> username = Optional.empty();
        Optional<String> password = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "response": {
                    response = Response.fromString(input.nextString());
                    continue block10;
                }
                case "username": {
                    username = Optional.ofNullable(input.nextString());
                    continue block10;
                }
                case "password": {
                    password = Optional.ofNullable(input.nextString());
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AuthChallengeResponse(response, username, password);
    }

    public static enum Response {
        DEFAULT("Default"),
        CANCELAUTH("CancelAuth"),
        PROVIDECREDENTIALS("ProvideCredentials");

        private String value;

        private Response(String value) {
            this.value = value;
        }

        public static Response fromString(String s2) {
            return Arrays.stream(Response.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within Response "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Response fromJson(JsonInput input) {
            return Response.fromString(input.nextString());
        }
    }
}

