/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.InvalidSelectorException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.internal.Require;

public abstract class By {
    public static By id(String id) {
        return new ById(id);
    }

    public static By linkText(String linkText) {
        return new ByLinkText(linkText);
    }

    public static By partialLinkText(String partialLinkText) {
        return new ByPartialLinkText(partialLinkText);
    }

    public static By name(String name) {
        return new ByName(name);
    }

    public static By tagName(String tagName) {
        return new ByTagName(tagName);
    }

    public static By xpath(String xpathExpression) {
        return new ByXPath(xpathExpression);
    }

    public static By className(String className) {
        return new ByClassName(className);
    }

    public static By cssSelector(String cssSelector) {
        return new ByCssSelector(cssSelector);
    }

    public WebElement findElement(SearchContext context) {
        List<WebElement> allElements = this.findElements(context);
        if (allElements == null || allElements.isEmpty()) {
            throw new NoSuchElementException("Cannot locate an element using " + this.toString());
        }
        return allElements.get(0);
    }

    public abstract List<WebElement> findElements(SearchContext var1);

    protected WebDriver getWebDriver(SearchContext context) {
        if (context instanceof WebDriver) {
            return (WebDriver)context;
        }
        if (!(context instanceof WrapsDriver)) {
            throw new IllegalArgumentException("Context does not wrap a webdriver: " + context);
        }
        return ((WrapsDriver)((Object)context)).getWrappedDriver();
    }

    protected JavascriptExecutor getJavascriptExecutor(SearchContext context) {
        WebDriver driver = this.getWebDriver(context);
        if (!(context instanceof JavascriptExecutor)) {
            throw new IllegalArgumentException("Context does not provide a mechanism to execute JS: " + context);
        }
        return (JavascriptExecutor)((Object)driver);
    }

    public boolean equals(Object o) {
        if (!(o instanceof By)) {
            return false;
        }
        By that = (By)o;
        return this.toString().equals(that.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "[unknown locator]";
    }

    private static abstract class PreW3CLocator
    extends By
    implements Remotable {
        private final Remotable.Parameters remoteParams;
        private final ByCssSelector fallback;

        private PreW3CLocator(String using, String value, String formatString) {
            this.remoteParams = new Remotable.Parameters(using, value);
            this.fallback = new ByCssSelector(String.format(formatString, this.cssEscape(value)));
        }

        @Override
        public WebElement findElement(SearchContext context) {
            return context.findElement(this.fallback);
        }

        @Override
        public List<WebElement> findElements(SearchContext context) {
            return context.findElements(this.fallback);
        }

        @Override
        public final Remotable.Parameters getRemoteParameters() {
            return this.remoteParams;
        }

        protected final Map<String, Object> toJson() {
            return this.fallback.toJson();
        }

        private String cssEscape(String using) {
            if ((using = using.replaceAll("([\\s'\"\\\\#.:;,!?+<>=~*^$|%&@`{}\\-\\/\\[\\]\\(\\)])", "\\\\$1")).length() > 0 && Character.isDigit(using.charAt(0))) {
                using = "\\" + (30 + Integer.parseInt(using.substring(0, 1))) + " " + using.substring(1);
            }
            return using;
        }
    }

    private static abstract class BaseW3CLocator
    extends By
    implements Remotable {
        private final Remotable.Parameters params;

        protected BaseW3CLocator(String using, String value) {
            this.params = new Remotable.Parameters(using, value);
        }

        @Override
        public WebElement findElement(SearchContext context) {
            Require.nonNull("Search Context", context);
            return context.findElement(this);
        }

        @Override
        public List<WebElement> findElements(SearchContext context) {
            Require.nonNull("Search Context", context);
            return context.findElements(this);
        }

        @Override
        public final Remotable.Parameters getRemoteParameters() {
            return this.params;
        }

        protected final Map<String, Object> toJson() {
            return this.getRemoteParameters().toJson();
        }
    }

    public static interface Remotable {
        public Parameters getRemoteParameters();

        public static class Parameters {
            private final String using;
            private final Object value;

            public Parameters(String using, Object value) {
                this.using = Require.nonNull("Search mechanism", using);
                this.value = value;
            }

            public String using() {
                return this.using;
            }

            public Object value() {
                return this.value;
            }

            public String toString() {
                return "[" + this.using + ": " + this.value + "]";
            }

            public boolean equals(Object o) {
                if (!(o instanceof Parameters)) {
                    return false;
                }
                Parameters that = (Parameters)o;
                return this.using.equals(that.using) && Objects.equals(this.value, that.value);
            }

            public int hashCode() {
                return Objects.hash(this.using, this.value);
            }

            private Map<String, Object> toJson() {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("using", this.using);
                params.put("value", this.value);
                return Collections.unmodifiableMap(params);
            }
        }
    }

    public static class ByCssSelector
    extends BaseW3CLocator {
        private final String cssSelector;

        public ByCssSelector(String cssSelector) {
            super("css selector", Require.argument("CSS selector", cssSelector).nonNull("Cannot find elements when the selector is null", new Object[0]));
            this.cssSelector = cssSelector;
        }

        @Override
        public String toString() {
            return "By.cssSelector: " + this.cssSelector;
        }
    }

    public static class ByClassName
    extends PreW3CLocator {
        private final String className;

        public ByClassName(String className) {
            super("class", Require.argument("Class name", className).nonNull("Cannot find elements when the class name expression is null.", new Object[0]), ".%s");
            if (className.matches(".*\\s.*")) {
                throw new InvalidSelectorException("Compound class names not permitted");
            }
            this.className = className;
        }

        @Override
        public String toString() {
            return "By.className: " + this.className;
        }
    }

    public static class ByXPath
    extends BaseW3CLocator {
        private final String xpathExpression;

        public ByXPath(String xpathExpression) {
            super("xpath", Require.argument("XPath", xpathExpression).nonNull("Cannot find elements when the XPath is null.", new Object[0]));
            this.xpathExpression = xpathExpression;
        }

        @Override
        public String toString() {
            return "By.xpath: " + this.xpathExpression;
        }
    }

    public static class ByTagName
    extends BaseW3CLocator {
        private final String tagName;

        public ByTagName(String tagName) {
            super("tag name", Require.argument("Tag name", tagName).nonNull("Cannot find elements when the tag name is null.", new Object[0]));
            if (tagName.isEmpty()) {
                throw new InvalidSelectorException("Tag name must not be blank");
            }
            this.tagName = tagName;
        }

        @Override
        public String toString() {
            return "By.tagName: " + this.tagName;
        }
    }

    public static class ByName
    extends PreW3CLocator {
        private final String name;

        public ByName(String name) {
            super("name", Require.argument("Name", name).nonNull("Cannot find elements when name text is null.", new Object[0]), String.format("*[name='%s']", name.replace("'", "\\'")));
            this.name = name;
        }

        @Override
        public String toString() {
            return "By.name: " + this.name;
        }
    }

    public static class ByPartialLinkText
    extends BaseW3CLocator {
        private final String partialLinkText;

        public ByPartialLinkText(String partialLinkText) {
            super("partial link text", Require.argument("Partial link text", partialLinkText).nonNull("Cannot find elements when the link text is null.", new Object[0]));
            this.partialLinkText = partialLinkText;
        }

        @Override
        public String toString() {
            return "By.partialLinkText: " + this.partialLinkText;
        }
    }

    public static class ByLinkText
    extends BaseW3CLocator {
        private final String linkText;

        public ByLinkText(String linkText) {
            super("link text", Require.argument("Link text", linkText).nonNull("Cannot find elements when the link text is null.", new Object[0]));
            this.linkText = linkText;
        }

        @Override
        public String toString() {
            return "By.linkText: " + this.linkText;
        }
    }

    public static class ById
    extends PreW3CLocator {
        private final String id;

        public ById(String id) {
            super("id", Require.argument("Id", id).nonNull("Cannot find elements when id is null.", new Object[0]), "#%s");
            this.id = id;
        }

        @Override
        public String toString() {
            return "By.id: " + this.id;
        }
    }
}

