/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.nextgen;

import graphql.Assert;
import graphql.Internal;
import graphql.execution.MissingRootTypeException;
import graphql.language.OperationDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import java.util.Optional;

@Internal
public class Common {
    public static GraphQLObjectType getOperationRootType(GraphQLSchema graphQLSchema, OperationDefinition operationDefinition) {
        OperationDefinition.Operation operation = operationDefinition.getOperation();
        if (operation == OperationDefinition.Operation.MUTATION) {
            GraphQLObjectType mutationType = graphQLSchema.getMutationType();
            return Optional.ofNullable(mutationType).orElseThrow(() -> new MissingRootTypeException("Schema is not configured for mutations.", operationDefinition.getSourceLocation()));
        }
        if (operation == OperationDefinition.Operation.QUERY) {
            GraphQLObjectType queryType = graphQLSchema.getQueryType();
            return Optional.ofNullable(queryType).orElseThrow(() -> new MissingRootTypeException("Schema does not define the required query root type.", operationDefinition.getSourceLocation()));
        }
        if (operation == OperationDefinition.Operation.SUBSCRIPTION) {
            GraphQLObjectType subscriptionType = graphQLSchema.getSubscriptionType();
            return Optional.ofNullable(subscriptionType).orElseThrow(() -> new MissingRootTypeException("Schema is not configured for subscriptions.", operationDefinition.getSourceLocation()));
        }
        return (GraphQLObjectType)Assert.assertShouldNeverHappen("Unhandled case.  An extra operation enum has been added without code support", new Object[0]);
    }
}

