/*
 * Decompiled with CFR 0.152.
 */
package zmq.io;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import zmq.Config;
import zmq.Msg;
import zmq.Options;
import zmq.SocketBase;
import zmq.ZError;
import zmq.ZMQ;
import zmq.io.IEngine;
import zmq.io.IOObject;
import zmq.io.IOThread;
import zmq.io.Metadata;
import zmq.io.Msgs;
import zmq.io.SessionBase;
import zmq.io.coder.IDecoder;
import zmq.io.coder.IEncoder;
import zmq.io.coder.raw.RawDecoder;
import zmq.io.coder.raw.RawEncoder;
import zmq.io.coder.v1.V1Decoder;
import zmq.io.coder.v1.V1Encoder;
import zmq.io.coder.v2.V2Decoder;
import zmq.io.coder.v2.V2Encoder;
import zmq.io.mechanism.Mechanism;
import zmq.io.mechanism.Mechanisms;
import zmq.io.net.Address;
import zmq.poll.IPollEvents;
import zmq.poll.Poller;
import zmq.util.Blob;
import zmq.util.Errno;
import zmq.util.Utils;
import zmq.util.ValueReference;
import zmq.util.Wire;
import zmq.util.function.Function;
import zmq.util.function.Supplier;

public class StreamEngine
implements IEngine,
IPollEvents {
    private IOObject ioObject;
    private SocketChannel fd;
    private Poller.Handle handle;
    private ByteBuffer inpos;
    private int insize;
    private IDecoder decoder;
    private final ValueReference<ByteBuffer> outpos;
    private int outsize;
    private IEncoder encoder;
    private Metadata metadata;
    private boolean handshaking;
    private static final int SIGNATURE_SIZE = 10;
    private static final int V2_GREETING_SIZE = 12;
    private static final int V3_GREETING_SIZE = 64;
    private int greetingSize;
    private final ByteBuffer greetingRecv;
    private final ByteBuffer greetingSend;
    private Protocol zmtpVersion;
    private SessionBase session;
    private final Options options;
    private final String endpoint;
    private boolean plugged;
    private Supplier<Msg> nextMsg;
    private Function<Msg, Boolean> processMsg;
    private boolean ioError;
    private boolean subscriptionRequired;
    private Mechanism mechanism;
    private boolean inputStopped;
    private boolean outputStopped;
    private static final int HANDSHAKE_TIMER_ID = 64;
    private static final int HEARTBEAT_TTL_TIMER_ID = 128;
    private static final int HEARTBEAT_IVL_TIMER_ID = 129;
    private static final int HEARTBEAT_TIMEOUT_TIMER_ID = 130;
    private boolean hasHandshakeTimer;
    private boolean hasTtlTimer;
    private boolean hasTimeoutTimer;
    private boolean hasHeartbeatTimer;
    private final int heartbeatTimeout;
    private final byte[] heartbeatContext;
    private SocketBase socket;
    private final Address peerAddress;
    private final Errno errno;
    private final Function<Msg, Boolean> processIdentity = this::processIdentityMsg;
    private final Supplier<Msg> nextIdentity = this::identityMsg;
    private final Function<Msg, Boolean> processHandshakeCommand = this::processHandshakeCommand;
    private final Supplier<Msg> nextHandshakeCommand = this::nextHandshakeCommand;
    private final Function<Msg, Boolean> pushMsgToSession = this::pushMsgToSession;
    private final Supplier<Msg> pullMsgFromSession = this::pullMsgFromSession;
    private final Function<Msg, Boolean> pushRawMsgToSession = this::pushRawMsgToSession;
    private final Function<Msg, Boolean> writeCredential = this::writeCredential;
    private final Supplier<Msg> pullAndEncode = this::pullAndEncode;
    private final Function<Msg, Boolean> decodeAndPush = this::decodeAndPush;
    private final Function<Msg, Boolean> pushOneThenDecodeAndPush = this::pushOneThenDecodeAndPush;
    private final Supplier<Msg> producePingMessage = this::producePingMessage;

    public StreamEngine(SocketChannel fd, Options options, String endpoint) {
        this.errno = options.errno;
        this.fd = fd;
        this.handshaking = true;
        this.greetingSize = 12;
        this.options = options;
        this.endpoint = endpoint;
        this.nextMsg = this.nextIdentity;
        this.processMsg = this.processIdentity;
        this.outpos = new ValueReference();
        this.greetingRecv = ByteBuffer.allocate(64);
        this.greetingSend = ByteBuffer.allocate(64);
        try {
            Utils.unblockSocket(this.fd);
        }
        catch (IOException e) {
            throw new ZError.IOException(e);
        }
        this.peerAddress = Utils.getPeerIpAddress(fd);
        this.heartbeatTimeout = this.heartbeatTimeout();
        this.heartbeatContext = Arrays.copyOf(options.heartbeatContext, options.heartbeatContext.length);
    }

    private int heartbeatTimeout() {
        int timeout = 0;
        if (this.options.heartbeatInterval > 0 && (timeout = this.options.heartbeatTimeout) == -1) {
            timeout = this.options.heartbeatInterval;
        }
        return timeout;
    }

    public void destroy() {
        assert (!this.plugged);
        if (this.fd != null) {
            block7: {
                try {
                    this.fd.close();
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block7;
                    throw new AssertionError();
                }
            }
            this.fd = null;
        }
        if (this.encoder != null) {
            this.encoder.destroy();
        }
        if (this.decoder != null) {
            this.decoder.destroy();
        }
        if (this.mechanism != null) {
            this.mechanism.destroy();
        }
    }

    @Override
    public void plug(IOThread ioThread, SessionBase session) {
        assert (!this.plugged);
        this.plugged = true;
        assert (this.session == null);
        assert (session != null);
        this.session = session;
        this.socket = session.getSocket();
        this.ioObject = new IOObject(ioThread, this);
        this.ioObject.plug();
        this.handle = this.ioObject.addFd(this.fd);
        this.ioError = false;
        int inBatchSize = Math.max(this.options.rcvbuf, Config.IN_BATCH_SIZE.getValue());
        int outBatchSize = Math.max(this.options.sndbuf, Config.OUT_BATCH_SIZE.getValue());
        if (this.options.rawSocket) {
            this.decoder = this.instantiate(this.options.decoder, inBatchSize, this.options.maxMsgSize);
            if (this.decoder == null) {
                this.decoder = new RawDecoder(inBatchSize);
            }
            this.encoder = this.instantiate(this.options.encoder, outBatchSize, this.options.maxMsgSize);
            if (this.encoder == null) {
                this.encoder = new RawEncoder(this.errno, outBatchSize);
            }
            this.handshaking = false;
            this.nextMsg = this.pullMsgFromSession;
            this.processMsg = this.pushRawMsgToSession;
            if (this.peerAddress != null && !this.peerAddress.address().isEmpty()) {
                assert (this.metadata == null);
                this.metadata = new Metadata();
                this.metadata.set("Peer-Address", this.peerAddress.address());
            }
            Msg connector = new Msg();
            this.pushRawMsgToSession(connector);
            session.flush();
        } else {
            this.setHandshakeTimer();
            this.greetingSend.put((byte)-1);
            Wire.putUInt64(this.greetingSend, this.options.identitySize + 1);
            this.greetingSend.put((byte)127);
            this.outpos.set(this.greetingSend);
            this.outsize = this.greetingSend.position();
            this.greetingSend.flip();
        }
        this.ioObject.setPollIn(this.handle);
        this.ioObject.setPollOut(this.handle);
        this.inEvent();
    }

    private <T> T instantiate(Class<T> clazz, int size, long max) {
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.getConstructor(Integer.TYPE, Long.TYPE).newInstance(size, max);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ZError.InstantiationException(e);
        }
    }

    private void unplug() {
        assert (this.plugged);
        this.plugged = false;
        if (this.hasHandshakeTimer) {
            this.ioObject.cancelTimer(64);
            this.hasHandshakeTimer = false;
        }
        if (this.hasTtlTimer) {
            this.ioObject.cancelTimer(128);
            this.hasTtlTimer = false;
        }
        if (this.hasTimeoutTimer) {
            this.ioObject.cancelTimer(130);
            this.hasTimeoutTimer = false;
        }
        if (this.hasHeartbeatTimer) {
            this.ioObject.cancelTimer(129);
            this.hasHeartbeatTimer = false;
        }
        if (!this.ioError) {
            this.ioObject.removeHandle(this.handle);
            this.handle = null;
        }
        this.ioObject.unplug();
        this.session = null;
    }

    @Override
    public void terminate() {
        this.unplug();
        this.destroy();
    }

    @Override
    public void inEvent() {
        int rc;
        assert (!this.ioError);
        if (this.handshaking && !this.handshake()) {
            return;
        }
        assert (this.decoder != null);
        if (this.inputStopped) {
            this.ioObject.removeHandle(this.handle);
            this.handle = null;
            this.ioError = true;
            return;
        }
        if (this.insize == 0) {
            this.inpos = this.decoder.getBuffer();
            rc = this.read(this.inpos);
            if (rc == 0) {
                this.error(ErrorReason.CONNECTION);
            }
            if (rc == -1) {
                if (!this.errno.is(35)) {
                    this.error(ErrorReason.CONNECTION);
                }
                return;
            }
            this.inpos.flip();
            this.insize = rc;
        }
        rc = 0;
        ValueReference<Integer> processed = new ValueReference<Integer>(0);
        while (this.insize > 0) {
            IDecoder.Step.Result result = this.decoder.decode(this.inpos, this.insize, processed);
            assert (processed.get() <= this.insize);
            this.insize -= processed.get().intValue();
            if (result == IDecoder.Step.Result.MORE_DATA) {
                rc = 1;
                break;
            }
            if (result == IDecoder.Step.Result.ERROR) {
                rc = 0;
                break;
            }
            Msg msg = this.decoder.msg();
            rc = this.processMsg.apply(msg).booleanValue() ? 1 : 0;
            if (rc != 0) continue;
            break;
        }
        if (rc == 0) {
            if (!this.errno.is(35)) {
                this.error(ErrorReason.PROTOCOL);
                return;
            }
            this.inputStopped = true;
            this.ioObject.resetPollIn(this.handle);
        }
        this.session.flush();
    }

    @Override
    public void outEvent() {
        int nbytes;
        assert (!this.ioError);
        if (this.outsize == 0) {
            Msg msg;
            if (this.encoder == null) {
                assert (this.handshaking);
                return;
            }
            this.outpos.set(null);
            this.outsize = this.encoder.encode(this.outpos, 0);
            int outBatchSize = Math.max(this.options.sndbuf, Config.OUT_BATCH_SIZE.getValue());
            while (this.outsize < outBatchSize && (msg = this.nextMsg.get()) != null) {
                this.encoder.loadMsg(msg);
                int n = this.encoder.encode(this.outpos, outBatchSize - this.outsize);
                assert (n > 0);
                this.outsize += n;
            }
            if (this.outsize == 0) {
                this.outputStopped = true;
                this.ioObject.resetPollOut(this.handle);
                return;
            }
            this.encoder.encoded();
        }
        if ((nbytes = this.write(this.outpos.get())) == -1) {
            this.ioObject.resetPollOut(this.handle);
            return;
        }
        this.outsize -= nbytes;
        if (this.handshaking && this.outsize == 0) {
            this.ioObject.resetPollOut(this.handle);
        }
    }

    @Override
    public void restartOutput() {
        if (this.ioError) {
            return;
        }
        if (this.outputStopped) {
            this.ioObject.setPollOut(this.handle);
            this.outputStopped = false;
        }
        this.outEvent();
    }

    @Override
    public void restartInput() {
        assert (this.inputStopped);
        assert (this.session != null);
        assert (this.decoder != null);
        Msg msg = this.decoder.msg();
        if (!this.processMsg.apply(msg).booleanValue()) {
            if (this.errno.is(35)) {
                this.session.flush();
            } else {
                this.error(ErrorReason.PROTOCOL);
            }
            return;
        }
        boolean decodingSuccess = this.decodeCurrentInputs();
        if (!decodingSuccess && this.errno.is(35)) {
            this.session.flush();
        } else if (this.ioError) {
            this.error(ErrorReason.CONNECTION);
        } else if (!decodingSuccess) {
            this.error(ErrorReason.PROTOCOL);
        } else {
            this.inputStopped = false;
            this.ioObject.setPollIn(this.handle);
            this.session.flush();
            this.inEvent();
        }
    }

    private boolean decodeCurrentInputs() {
        while (this.insize > 0) {
            ValueReference<Integer> processed = new ValueReference<Integer>(0);
            IDecoder.Step.Result result = this.decoder.decode(this.inpos, this.insize, processed);
            assert (processed.get() <= this.insize);
            this.insize -= processed.get().intValue();
            if (result == IDecoder.Step.Result.MORE_DATA) {
                return true;
            }
            if (result == IDecoder.Step.Result.ERROR) {
                return false;
            }
            if (this.processMsg.apply(this.decoder.msg()).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private boolean handshake() {
        assert (this.handshaking);
        assert (this.greetingRecv.position() < this.greetingSize);
        Mechanisms mechanism = this.options.mechanism;
        assert (mechanism != null);
        int revisionPos = 10;
        int inBatchSize = Math.max(this.options.rcvbuf, Config.IN_BATCH_SIZE.getValue());
        int outBatchSize = Math.max(this.options.sndbuf, Config.OUT_BATCH_SIZE.getValue());
        while (this.greetingRecv.position() < this.greetingSize) {
            int n = this.read(this.greetingRecv);
            if (n == 0) {
                this.error(ErrorReason.CONNECTION);
                return false;
            }
            if (n == -1) {
                if (!this.errno.is(35)) {
                    this.error(ErrorReason.CONNECTION);
                }
                return false;
            }
            if ((this.greetingRecv.get(0) & 0xFF) != 255) break;
            if (this.greetingRecv.position() < 10) continue;
            if ((this.greetingRecv.get(9) & 1) != 1) break;
            int outpos = this.greetingSend.position();
            if (this.greetingSend.limit() == 10) {
                if (this.outsize == 0) {
                    this.ioObject.setPollOut(this.handle);
                }
                this.greetingSend.limit(11);
                this.greetingSend.put(10, Protocol.V3.revision);
                ++this.outsize;
            }
            if (this.greetingRecv.position() > 10 && this.greetingSend.limit() == 11) {
                byte protocol;
                if (this.outsize == 0) {
                    this.ioObject.setPollOut(this.handle);
                }
                if ((protocol = this.greetingRecv.get(10)) == Protocol.V1.revision || protocol == Protocol.V2.revision) {
                    this.greetingSend.limit(12);
                    this.greetingSend.position(11);
                    this.greetingSend.put((byte)this.options.type);
                    ++this.outsize;
                } else {
                    this.greetingSend.limit(64);
                    this.greetingSend.position(11);
                    this.greetingSend.put((byte)0);
                    ++this.outsize;
                    this.greetingSend.mark();
                    this.greetingSend.put(new byte[20]);
                    assert (mechanism == Mechanisms.NULL || mechanism == Mechanisms.PLAIN || mechanism == Mechanisms.CURVE || mechanism == Mechanisms.GSSAPI);
                    this.greetingSend.reset();
                    this.greetingSend.put(mechanism.name().getBytes(ZMQ.CHARSET));
                    this.greetingSend.reset();
                    this.greetingSend.position(this.greetingSend.position() + 20);
                    this.outsize += 20;
                    this.greetingSend.put(new byte[32]);
                    this.outsize += 32;
                    this.greetingSize = 64;
                }
            }
            this.greetingSend.position(outpos);
        }
        if ((this.greetingRecv.get(0) & 0xFF) != 255 || (this.greetingRecv.get(9) & 1) == 0) {
            if (this.session.zapEnabled()) {
                this.error(ErrorReason.PROTOCOL);
                return false;
            }
            this.zmtpVersion = Protocol.V0;
            this.encoder = new V1Encoder(this.errno, outBatchSize);
            this.decoder = new V1Decoder(this.errno, inBatchSize, this.options.maxMsgSize, this.options.allocator);
            int headerSize = this.options.identitySize + 1 >= 255 ? 10 : 2;
            ByteBuffer tmp = ByteBuffer.allocate(headerSize);
            Msg txMsg = new Msg(this.options.identitySize);
            txMsg.put(this.options.identity, 0, (int)this.options.identitySize);
            this.encoder.loadMsg(txMsg);
            ValueReference<ByteBuffer> bufferp = new ValueReference<ByteBuffer>(tmp);
            int bufferSize = this.encoder.encode(bufferp, headerSize);
            assert (bufferSize == headerSize);
            this.decodeDataAfterHandshake(0);
            if (this.options.type == 1 || this.options.type == 9) {
                this.subscriptionRequired = true;
            }
            this.nextMsg = this.pullMsgFromSession;
            this.processMsg = this.processIdentity;
        } else if (this.greetingRecv.get(10) == Protocol.V1.revision) {
            this.zmtpVersion = Protocol.V1;
            if (this.session.zapEnabled()) {
                this.error(ErrorReason.PROTOCOL);
                return false;
            }
            this.encoder = new V1Encoder(this.errno, outBatchSize);
            this.decoder = new V1Decoder(this.errno, inBatchSize, this.options.maxMsgSize, this.options.allocator);
            this.decodeDataAfterHandshake(12);
        } else if (this.greetingRecv.get(10) == Protocol.V2.revision) {
            this.zmtpVersion = Protocol.V2;
            if (this.session.zapEnabled()) {
                this.error(ErrorReason.PROTOCOL);
                return false;
            }
            this.encoder = new V2Encoder(this.errno, outBatchSize);
            this.decoder = new V2Decoder(this.errno, inBatchSize, this.options.maxMsgSize, this.options.allocator);
            this.decodeDataAfterHandshake(12);
        } else {
            this.zmtpVersion = Protocol.V3;
            this.encoder = new V2Encoder(this.errno, outBatchSize);
            this.decoder = new V2Decoder(this.errno, inBatchSize, this.options.maxMsgSize, this.options.allocator);
            this.greetingRecv.position(12);
            if (!mechanism.isMechanism(this.greetingRecv)) {
                this.error(ErrorReason.PROTOCOL);
                return false;
            }
            this.mechanism = mechanism.create(this.session, this.peerAddress, this.options);
            this.nextMsg = this.nextHandshakeCommand;
            this.processMsg = this.processHandshakeCommand;
        }
        if (this.outsize == 0) {
            this.ioObject.setPollOut(this.handle);
        }
        this.handshaking = false;
        if (this.hasHandshakeTimer) {
            this.ioObject.cancelTimer(64);
            this.hasHandshakeTimer = false;
        }
        this.socket.eventHandshaken(this.endpoint, this.zmtpVersion.ordinal());
        return true;
    }

    private void decodeDataAfterHandshake(int greetingSize) {
        int pos = this.greetingRecv.position();
        if (pos > greetingSize) {
            this.greetingRecv.position(greetingSize).limit(pos);
            this.inpos = this.greetingRecv;
            this.insize = this.greetingRecv.remaining();
        }
    }

    private Msg identityMsg() {
        Msg msg = new Msg(this.options.identitySize);
        if (this.options.identitySize > 0) {
            msg.put(this.options.identity, 0, (int)this.options.identitySize);
        }
        this.nextMsg = this.pullMsgFromSession;
        return msg;
    }

    private boolean processIdentityMsg(Msg msg) {
        if (this.options.recvIdentity) {
            msg.setFlags(64);
            boolean rc = this.session.pushMsg(msg);
            assert (rc);
        }
        if (this.subscriptionRequired) {
            Msg subscription = new Msg(1);
            subscription.put((byte)1);
            boolean rc = this.session.pushMsg(subscription);
            assert (rc);
        }
        this.processMsg = this.pushMsgToSession;
        return true;
    }

    private Msg nextHandshakeCommand() {
        assert (this.mechanism != null);
        if (this.mechanism.status() == Mechanism.Status.READY) {
            this.mechanismReady();
            return this.pullAndEncode.get();
        }
        if (this.mechanism.status() == Mechanism.Status.ERROR) {
            this.errno.set(156384820);
            return null;
        }
        Msg.Builder msg = new Msg.Builder();
        int rc = this.mechanism.nextHandshakeCommand(msg);
        if (rc == 0) {
            msg.setFlags(2);
            return msg.build();
        }
        this.errno.set(rc);
        return null;
    }

    private boolean processHandshakeCommand(Msg msg) {
        assert (this.mechanism != null);
        int rc = this.mechanism.processHandshakeCommand(msg);
        if (rc == 0) {
            if (this.mechanism.status() == Mechanism.Status.READY) {
                this.mechanismReady();
            } else if (this.mechanism.status() == Mechanism.Status.ERROR) {
                this.errno.set(156384820);
                return false;
            }
            if (this.outputStopped) {
                this.restartOutput();
            }
        } else {
            this.errno.set(rc);
        }
        return rc == 0;
    }

    @Override
    public void zapMsgAvailable() {
        assert (this.mechanism != null);
        int rc = this.mechanism.zapMsgAvailable();
        if (rc == -1) {
            this.error(ErrorReason.PROTOCOL);
            return;
        }
        if (this.inputStopped) {
            this.restartInput();
        }
        if (this.outputStopped) {
            this.restartOutput();
        }
    }

    private void mechanismReady() {
        if (this.options.heartbeatInterval > 0) {
            this.ioObject.addTimer(this.options.heartbeatInterval, 129);
            this.hasHeartbeatTimer = true;
        }
        if (this.options.recvIdentity) {
            Msg identity = this.mechanism.peerIdentity();
            boolean rc = this.session.pushMsg(identity);
            if (!rc && this.errno.is(35)) {
                return;
            }
            assert (rc);
            this.session.flush();
        }
        this.nextMsg = this.pullAndEncode;
        this.processMsg = this.writeCredential;
        assert (this.metadata == null);
        this.metadata = new Metadata();
        if (this.peerAddress != null && !this.peerAddress.address().isEmpty()) {
            this.metadata.set("Peer-Address", this.peerAddress.address());
        }
        this.metadata.set(this.mechanism.zapProperties);
        this.metadata.set(this.mechanism.zmtpProperties);
        if (this.metadata.isEmpty()) {
            this.metadata = null;
        }
    }

    private Msg pullMsgFromSession() {
        return this.session.pullMsg();
    }

    private boolean pushMsgToSession(Msg msg) {
        return this.session.pushMsg(msg);
    }

    private boolean pushRawMsgToSession(Msg msg) {
        if (this.metadata != null && !this.metadata.equals(msg.getMetadata())) {
            msg.setMetadata(this.metadata);
        }
        return this.pushMsgToSession(msg);
    }

    private boolean writeCredential(Msg msg) {
        assert (this.mechanism != null);
        assert (this.session != null);
        Blob credential = this.mechanism.getUserId();
        if (credential != null && credential.size() > 0) {
            Msg cred = new Msg(credential.size());
            cred.put(credential.data(), 0, credential.size());
            cred.setFlags(32);
            boolean rc = this.session.pushMsg(cred);
            if (!rc) {
                return false;
            }
        }
        this.processMsg = this.decodeAndPush;
        return this.decodeAndPush.apply(msg);
    }

    private Msg pullAndEncode() {
        assert (this.mechanism != null);
        Msg msg = this.session.pullMsg();
        if (msg == null) {
            return null;
        }
        msg = this.mechanism.encode(msg);
        return msg;
    }

    private boolean decodeAndPush(Msg msg) {
        boolean rc;
        assert (this.mechanism != null);
        if ((msg = this.mechanism.decode(msg)) == null) {
            return false;
        }
        if (this.hasTimeoutTimer) {
            this.hasTimeoutTimer = false;
            this.ioObject.cancelTimer(130);
        }
        if (this.hasTtlTimer) {
            this.hasTtlTimer = false;
            this.ioObject.cancelTimer(128);
        }
        if (msg.isCommand()) {
            this.processCommand(msg);
        }
        if (this.metadata != null) {
            msg.setMetadata(this.metadata);
        }
        if (!(rc = this.session.pushMsg(msg))) {
            if (this.errno.is(35)) {
                this.processMsg = this.pushOneThenDecodeAndPush;
            }
            return false;
        }
        return true;
    }

    private boolean pushOneThenDecodeAndPush(Msg msg) {
        boolean rc = this.session.pushMsg(msg);
        if (rc) {
            this.processMsg = this.decodeAndPush;
        }
        return rc;
    }

    private void error(ErrorReason error) {
        if (this.options.rawSocket) {
            Msg terminator = new Msg();
            this.processMsg.apply(terminator);
        }
        assert (this.session != null);
        this.socket.eventDisconnected(this.endpoint, this.fd);
        this.session.flush();
        this.session.engineError(error);
        this.unplug();
        this.destroy();
    }

    private void setHandshakeTimer() {
        assert (!this.hasHandshakeTimer);
        if (!this.options.rawSocket && this.options.handshakeIvl > 0) {
            this.ioObject.addTimer(this.options.handshakeIvl, 64);
            this.hasHandshakeTimer = true;
        }
    }

    @Override
    public void timerEvent(int id) {
        if (id == 64) {
            this.hasHandshakeTimer = false;
            this.error(ErrorReason.TIMEOUT);
        } else if (id == 129) {
            this.nextMsg = this.producePingMessage;
            this.outEvent();
            this.ioObject.addTimer(this.options.heartbeatInterval, 129);
        } else if (id == 128) {
            this.hasTtlTimer = false;
            this.error(ErrorReason.TIMEOUT);
        } else if (id == 130) {
            this.hasTimeoutTimer = false;
            this.error(ErrorReason.TIMEOUT);
        } else assert (false);
    }

    private Msg producePingMessage() {
        assert (this.mechanism != null);
        Msg msg = new Msg(7 + this.heartbeatContext.length);
        msg.setFlags(2);
        msg.putShortString("PING");
        Wire.putUInt16(msg, this.options.heartbeatTtl);
        msg.put(this.heartbeatContext);
        msg = this.mechanism.encode(msg);
        this.nextMsg = this.pullAndEncode;
        if (!this.hasTimeoutTimer && this.heartbeatTimeout > 0) {
            this.ioObject.addTimer(this.heartbeatTimeout, 130);
            this.hasTimeoutTimer = true;
        }
        return msg;
    }

    private Msg producePongMessage(byte[] pingContext) {
        assert (this.mechanism != null);
        assert (pingContext != null);
        Msg msg = new Msg(5 + pingContext.length);
        msg.setFlags(2);
        msg.putShortString("PONG");
        msg.put(pingContext);
        msg = this.mechanism.encode(msg);
        this.nextMsg = this.pullAndEncode;
        return msg;
    }

    private boolean processCommand(Msg msg) {
        if (Msgs.startsWith(msg, "PING", true)) {
            return this.processHeartbeatMessage(msg);
        }
        return false;
    }

    private boolean processHeartbeatMessage(Msg msg) {
        int remaining;
        int remoteHeartbeatTtl = msg.getShort(5);
        if (!this.hasTtlTimer && (remoteHeartbeatTtl *= 100) > 0) {
            this.ioObject.addTimer(remoteHeartbeatTtl, 128);
            this.hasTtlTimer = true;
        }
        if ((remaining = msg.size() - 7) > 16) {
            remaining = 16;
        }
        byte[] pingContext = new byte[remaining];
        msg.getBytes(7, pingContext, 0, remaining);
        this.nextMsg = new ProducePongMessage(pingContext);
        this.outEvent();
        return true;
    }

    private int write(ByteBuffer outbuf) {
        int nbytes;
        try {
            nbytes = this.fd.write(outbuf);
            if (nbytes == 0) {
                this.errno.set(35);
            }
        }
        catch (IOException e) {
            this.errno.set(57);
            nbytes = -1;
        }
        return nbytes;
    }

    private int read(ByteBuffer buf) {
        int nbytes;
        try {
            nbytes = this.fd.read(buf);
            if (nbytes == -1) {
                this.errno.set(57);
            } else if (nbytes == 0 && !this.fd.isBlocking()) {
                this.errno.set(35);
                nbytes = -1;
            }
        }
        catch (IOException e) {
            this.errno.set(57);
            nbytes = -1;
        }
        return nbytes;
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.socket + "-" + (Object)((Object)this.zmtpVersion);
    }

    public static enum ErrorReason {
        PROTOCOL,
        CONNECTION,
        TIMEOUT;

    }

    private static enum Protocol {
        V0(-1),
        V1(0),
        V2(1),
        V3(3);

        private final byte revision;

        private Protocol(int revision) {
            this.revision = (byte)revision;
        }
    }

    private final class ProducePongMessage
    implements Supplier<Msg> {
        private final byte[] pingContext;

        public ProducePongMessage(byte[] pingContext) {
            assert (pingContext != null);
            this.pingContext = pingContext;
        }

        @Override
        public Msg get() {
            return StreamEngine.this.producePongMessage(this.pingContext);
        }
    }
}

