/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue;

import org.openqa.selenium.grid.data.SessionRequest;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueue;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;

class AddToSessionQueue
implements HttpHandler {
    private final Tracer tracer;
    private final NewSessionQueue newSessionQueue;

    AddToSessionQueue(Tracer tracer, NewSessionQueue newSessionQueue) {
        this.tracer = Require.nonNull("Tracer", tracer);
        this.newSessionQueue = Require.nonNull("New Session Queue", newSessionQueue);
    }

    @Override
    public HttpResponse execute(HttpRequest req) {
        try (Span span = HttpTracing.newSpanAsChildOf(this.tracer, req, "sessionqueue.add");){
            Tags.HTTP_REQUEST.accept(span, req);
            HttpResponse response = this.newSessionQueue.addToQueue((SessionRequest)Contents.fromJson(req, SessionRequest.class));
            Tags.HTTP_RESPONSE.accept(span, response);
            HttpResponse httpResponse = response;
            return httpResponse;
        }
    }
}

